package com.ydl.ydlcommon.utils;

import android.content.Context;
import android.util.Log;

import com.umeng.analytics.MobclickAgent;
import com.ydl.burypointlib.BuryPointHelper;
//import com.ydl.devicesidlib.DemoHelper;
import com.ydl.devicesidlib.DeviceIDHelper;
import com.ydl.pushserver.pushagent.YdlPushAgent;
import com.ydl.pushserver.pushagent.common.listener.IYDLPushListener;
import com.ydl.pushserver.pushagent.network.pack.RegisterEventBean;
import com.ydl.ydlcommon.base.BaseApp;
import com.ydl.ydlcommon.base.config.YDLConstants;
import com.ydl.ydlcommon.modular.ModularServiceManager;
import com.ydl.ydlcommon.router.YdlCommonOut;
import com.yidianling.common.tools.RxAppTool;
import com.yidianling.common.tools.RxDeviceTool;
import com.yidianling.common.tools.RxNetTool;

//import static com.bun.miitmdid.content.ContextKeeper.getApplicationContext;
//import com.ydl.burypointlib.BuryPointHelper;

//埋点工具类
public class YdlBuryPointUtil {

    private static Context context;

    //初始化
    public static void init(Context context1){
        init(context1,false);
    }

    public static void init(Context context1,Boolean isEditAlis){
        try {
            context = context1;
            String appEnv = BaseApp.instance.getGlobalConfig().getAppEnv();
            boolean appDebug = BaseApp.instance.getGlobalConfig().getAppDebug();
            boolean isTest = YDLConstants.ENV_TEST.equals(appEnv);
            if (isTest){
                YdlPushAgent.setDebugAdree("121.41.92.140",8091);
            }
            RegisterEventBean registerEventBean = new RegisterEventBean();
            registerEventBean.setAppId(context.getPackageName());
            registerEventBean.setAppVersion(RxAppTool.getAppVersionName(context));
                    String deviceId = DeviceIDHelper.getInstance().getDeviceId();
            registerEventBean.setDeviceId(deviceId);
            registerEventBean.setManufacturer(RxDeviceTool.getBuildMANUFACTURER());
            registerEventBean.setChannel(YdlCommonOut.Companion.getChannelName());
            registerEventBean.setOs("Android");
            registerEventBean.setModel(RxDeviceTool.getBuildBrandModel());
            registerEventBean.setOsVersion(RxDeviceTool.getOsBuileVersion());
            registerEventBean.setUid(ModularServiceManager.INSTANCE.getPlatformUserService().getUser().getUserId()+"");
            registerEventBean.setScreenHeight(RxDeviceTool.getScreenHeight(context));
            registerEventBean.setScreenWidth(RxDeviceTool.getScreenWidth(context));
            registerEventBean.setWifi(RxNetTool.getNetWorkTypeName(context));
            LogUtil.d(registerEventBean.toString());
            YdlPushAgent.init(registerEventBean,appDebug, context1, new IYDLPushListener() {
                @Override
                public void onPushEvent() {
                    MobclickAgent.onEvent(context1, "socket_push_event");
                }

                @Override
                public void onPushRescueEvent() {
                    MobclickAgent.onEvent(context1, "socket_push_rescue_event");
                }

                @Override
                public void onSocketReconnect() {
                    MobclickAgent.onEvent(context1, "socket_reconnect");
                }

                @Override
                public void onSocketDisconnect() {
                    MobclickAgent.onEvent(context1, "socket_disconnect");
                }
            });

            BuryPointHelper.setDebug(isTest,isEditAlis,true,appDebug);
            BuryPointHelper.init();

        }catch (Exception e){
            e.printStackTrace();
        }
    }


    //重新登录
    public static void reLogin(){
        try {
            RegisterEventBean registerEventBean = new RegisterEventBean();
            registerEventBean.setAppId(context.getPackageName());
            registerEventBean.setAppVersion(RxAppTool.getAppVersionName(context));
            String deviceId = DeviceIDHelper.getInstance().getDeviceId();
            registerEventBean.setDeviceId(deviceId);
            registerEventBean.setManufacturer(RxDeviceTool.getBuildMANUFACTURER());
            registerEventBean.setChannel(YdlCommonOut.Companion.getChannelName());
            registerEventBean.setOs("Android");
            registerEventBean.setModel(RxDeviceTool.getBuildBrandModel());
            registerEventBean.setOsVersion(RxDeviceTool.getOsBuileVersion());
            registerEventBean.setUid(ModularServiceManager.INSTANCE.getPlatformUserService().getUser().getUserId()+"");
            registerEventBean.setScreenHeight(RxDeviceTool.getScreenHeight(context));
            registerEventBean.setScreenWidth(RxDeviceTool.getScreenWidth(context));
            registerEventBean.setWifi(RxNetTool.getNetWorkTypeName(context));
            YdlPushAgent.reLogin(registerEventBean);

            LogUtil.d("reLogin:"+registerEventBean.toString());
        }catch (Exception e){
            LogUtil.e("reLogin:"+e.getMessage());
        }
    }

    //pv埋点
    public static void sendPv(String pageViewId){
        YdlPushAgent.sendPvEvent(pageViewId);
        LogUtil.d(pageViewId);
    }

    //click埋点
    public static void sendClick(String eventId,String... strings){
        com.yidianling.common.tools.LogUtil.d(eventId);
        YdlPushAgent.sendClickEvent(eventId,strings);
    }
}
