package com.ydl.ydlcommon.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;

import com.yidianling.common.tools.RxImageTool;
import com.ydl.ydlcommon.R;


/**
 * 右边有删除按钮的edit text
 * Created by Dog on 2015/6/29.
 */
@SuppressLint("AppCompatCustomView")
public class DeleteEditTextView extends EditText {

    int mCloseAreaSize;

    public DeleteEditTextView(Context context) {
        super(context);
        initRootView();
    }

    public DeleteEditTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initRootView();
    }

    public DeleteEditTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initRootView();
    }

    @Override
    public void setText(CharSequence text, BufferType type) {
        super.setText(text, type);
        setSelection(text.length());
    }

    /**
     * 初始化视图
     */
    void initRootView() {
        mCloseAreaSize = RxImageTool.dp2px(30);

        int padding = getResources().getDimensionPixelSize(R.dimen.platform_default_dis_size_small);
        setCompoundDrawablePadding(padding);
        setEditTextDrawable();

        addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                setEditTextDrawable();
            }
        });

        setOnFocusChangeListener(new OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                DeleteEditTextView.this.setEditTextDrawable();
            }
        });
    }

    void setEditTextDrawable() {
        if (getText().length() == 0 || !isFocused()) {
            setCompoundDrawablesWithIntrinsicBounds(getCompoundDrawables()[0], null, null, null);
        } else {
            setCompoundDrawablesWithIntrinsicBounds(getCompoundDrawables()[0], null, getContext().getResources().getDrawable(R.drawable.platform_delete), null);
        }
    }


    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if ((event.getAction() == 1) && isFocused()) {
            int i = (int) event.getRawX();
            if (i > getRight() - mCloseAreaSize) {
                setText("");
                event.setAction(MotionEvent.ACTION_CANCEL);
            }
        }
        return super.onTouchEvent(event);
    }


}
