package com.ydl.ydlcommon.view;

import android.content.Context;
import androidx.viewpager.widget.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;


/**
 * Created by softrice on 15/9/12.
 */
public class DisallowParentTouchViewPager extends ViewPager {

    public boolean isClick;

    private FixRequestDisallowTouchEventPtrFrameLayout parent;

    public DisallowParentTouchViewPager(Context context) {
        super(context);
    }

    public DisallowParentTouchViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setNestParent(FixRequestDisallowTouchEventPtrFrameLayout parent) {
        this.parent = parent;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        setIntercepTouchEvent(ev);
        return super.dispatchTouchEvent(ev);
    }

    private void setIntercepTouchEvent(MotionEvent ev) {
        if (parent != null) {
            parent.myRequestDisallowInterceptTouchEvent(true);
            if (ev.getAction() == MotionEvent.ACTION_CANCEL || ev.getAction() == MotionEvent.ACTION_UP) {
                parent.myRequestDisallowInterceptTouchEvent(false);
            }
        }
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {

        setIntercepTouchEvent(ev);
        return super.onInterceptTouchEvent(ev);
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {

        setIntercepTouchEvent(ev);
        return super.onTouchEvent(ev);
    }




}