package com.ydl.ydlcommon.view

import android.content.Context
import android.graphics.drawable.Drawable
import android.text.InputFilter
import android.util.AttributeSet
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import com.ydl.ydlcommon.R
import kotlinx.android.synthetic.main.platform_ui_jump_text_view.view.*

/**
 * 右侧带箭头，高度最低60dp，左侧可以设置图标，左侧文字，右侧文字，文字颜色
 * Created by Dog on 2015/6/24.
 */
class JumpTextView : FrameLayout {


    //内容
    internal var mLeftTextContent: String? = null
    internal var mRightTextContent: String? = null
    //文字大小
    internal var mLeftTextSize: Int = 0
    internal var mRightTextSize: Int = 0
    //颜色
    internal var mLeftTextColor: Int = 0
    internal var mRightTextColor: Int = 0
    //图标
    internal var mIconDrawable: Drawable? = null
    //图标大小
    internal var mLeftIconWidth: Int = 0
    internal var mLeftIconHeight: Int = 0
    //文字的最大行数
    internal var maxLine = -1
    //是否隐藏右箭头
    internal var hideArrow = false
    //右箭头资源文件id
    internal var arrowRes: Int = 0
    //右侧最多显示数字
    internal var rightMaxLength = -1
    //是否可以点击
    internal var isClickEnable = true
    //右侧文字gravity
    internal var rightGravity = 1
    //左侧文字宽度
    internal var leftTextWidth = -1
    //左侧小红点
    internal var isRedDotShow = false


    /**
     * 设置左侧文字
     */
    var leftText: String?
        get() = mLeftTextContent
        set(leftTextContent) {
            mLeftTextContent = leftTextContent
            setupViews()
        }

    /**
     * 设置右侧文字
     */
    var rightText: String?
        get() = mRightTextContent
        set(s) {
            if (s == null) return
            mRightTextContent = s
            setupViews()
        }

    constructor(context: Context) : super(context) {
        View.inflate(context, R.layout.platform_ui_jump_text_view, this)

        initRootView(null, 0)

        setupViews()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        View.inflate(context, R.layout.platform_ui_jump_text_view, this)

        initRootView(attrs, 0)

        setupViews()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        View.inflate(context, R.layout.platform_ui_jump_text_view, this)
        initRootView(attrs, defStyleAttr)

        setupViews()
    }

    /**
     * 设置左侧文字红点是否显示
     */
    fun setLeftRedDotVisibility(visibitity: Int) {
        img_reddot!!.visibility = visibitity
    }

    /**
     * 是否隐藏箭头
     *
     * @param isArrowShow 是否隐藏
     */
    fun setArrow(isArrowShow: Boolean) {
        hideArrow = !isArrowShow

        if (hideArrow) {
            arrowRes = 0
        } else {
            arrowRes = R.drawable.platform_mine_next
        }

        tv_right_text!!.setCompoundDrawablesWithIntrinsicBounds(0, 0, arrowRes, 0)
    }

    fun setClickEnable(enable: Boolean) {
        isClickEnable = enable
    }

    /**
     * 初始化根视图
     */
    internal fun initRootView(attrs: AttributeSet?, defStyleAttr: Int) {

        val a = context.obtainStyledAttributes(
                attrs, R.styleable.Platform_JumpTextView, defStyleAttr, 0)

        mLeftTextContent = a.getString(R.styleable.Platform_JumpTextView_pa_jump_tv_left_text)
        mLeftTextColor = a.getColor(R.styleable.Platform_JumpTextView_pa_jump_tv_left_color,
                resources.getColor(R.color.platform_default_text_color))
        mLeftTextSize = a.getDimensionPixelSize(R.styleable.Platform_JumpTextView_pa_jump_tv_left_size,
                resources.getDimensionPixelSize(R.dimen.platform_default_text_size))

        mRightTextContent = a.getString(R.styleable.Platform_JumpTextView_pa_jump_tv_right_text)
        mRightTextColor = a.getColor(R.styleable.Platform_JumpTextView_pa_jump_tv_right_color,
                resources.getColor(R.color.platform_default_text_color))
        mRightTextSize = a.getDimensionPixelSize(R.styleable.Platform_JumpTextView_pa_jump_tv_right_size,
                resources.getDimensionPixelSize(R.dimen.platform_default_text_size))

        mIconDrawable = a.getDrawable(R.styleable.Platform_JumpTextView_pa_jump_tv_icon)

        mLeftIconWidth = a.getDimensionPixelSize(R.styleable.Platform_JumpTextView_pa_jump_tv_left_icon_width,
                -1)

        mLeftIconHeight = a.getDimensionPixelSize(R.styleable.Platform_JumpTextView_pa_jump_tv_left_icon_hight,
                -1)

        maxLine = a.getInteger(R.styleable.Platform_JumpTextView_pa_jump_tv_max_line, -1)

        hideArrow = a.getBoolean(R.styleable.Platform_JumpTextView_pa_jump_tv_hide_arrow, false)
        isClickEnable = a.getBoolean(R.styleable.Platform_JumpTextView_pa_jump_tv_can_click, !hideArrow)

        rightMaxLength = a.getInt(R.styleable.Platform_JumpTextView_pa_jump_tv_right_max_length, rightMaxLength)

        leftTextWidth = a.getDimensionPixelSize(R.styleable.Platform_JumpTextView_pa_jump_tv_left_width, -1)
        rightGravity = a.getInteger(R.styleable.Platform_JumpTextView_pa_jump_tv_right_gravity, 2)

        isRedDotShow = a.getBoolean(R.styleable.Platform_JumpTextView_pa_jump_tv_left_red_dot, false)

        a.recycle()
        minimumHeight = resources.getDimensionPixelSize(R.dimen.platform_jump_text_view_min_height)
        //setBackgroundColor(Color.WHITE);

        if (hideArrow) {
            arrowRes = 0
        } else {
            arrowRes = R.drawable.platform_mine_next
        }
        setWillNotDraw(false)
    }


    /**
     * 初始化子view
     */
    internal fun setupViews() {
        if (rightMaxLength != -1) {

            val filters = tv_right_text!!.filters
            val newFilters = arrayOfNulls<InputFilter>(filters.size + 1)
            System.arraycopy(filters, 0, newFilters, 0, filters.size)
            newFilters[filters.size] = InputFilter.LengthFilter(rightMaxLength)
            tv_right_text!!.filters = newFilters
        }

        tv_right_text!!.setCompoundDrawablesWithIntrinsicBounds(0, 0, arrowRes, 0)

        if (mIconDrawable != null) {
            iv_icon!!.visibility = View.VISIBLE
            iv_icon!!.setImageDrawable(mIconDrawable)
            if (mLeftIconWidth != -1 && mLeftIconHeight != -1) {
                iv_icon!!.layoutParams.height = mLeftIconHeight
                iv_icon!!.layoutParams.width = mLeftIconWidth
            }
        } else {
            iv_icon!!.visibility = View.GONE
        }

        tv_left_text!!.text = mLeftTextContent
        tv_left_text!!.setTextColor(mLeftTextColor)
        tv_left_text!!.setTextSize(TypedValue.COMPLEX_UNIT_PX, mLeftTextSize.toFloat())

        tv_right_text!!.text = mRightTextContent
        tv_right_text!!.setTextSize(TypedValue.COMPLEX_UNIT_PX, mRightTextSize.toFloat())
        tv_right_text!!.setTextColor(mRightTextColor)

        if (maxLine != -1) {
            tv_left_text!!.maxLines = maxLine
            tv_right_text!!.maxLines = maxLine
        }

        if (leftTextWidth != -1) {
            tv_left_text!!.width = leftTextWidth
        }

        if (rightGravity == 1) {
            tv_right_text!!.gravity = Gravity.LEFT
        } else {
            tv_right_text!!.gravity = Gravity.RIGHT
        }

        if (isRedDotShow) {
            img_reddot!!.visibility = View.VISIBLE
        } else {
            img_reddot!!.visibility = View.GONE
        }
    }

    fun setRighttextColor(color: Int) {
        this.mRightTextColor = color
        tv_right_text!!.setTextColor(color)
    }

    fun getTvIcon(): ImageView {
        return iv_icon!!
    }

    fun setTvIcon(iconDrawable: Drawable) {
        mIconDrawable  = iconDrawable
        iv_icon!!.visibility = View.VISIBLE
        iv_icon!!.setImageDrawable(mIconDrawable)
        if (mLeftIconWidth != -1 && mLeftIconHeight != -1) {
            iv_icon!!.layoutParams.height = mLeftIconHeight
            iv_icon!!.layoutParams.width = mLeftIconWidth
        }
    }

    fun setLefttextColor(color: Int) {
        this.mLeftTextColor = color
        tv_left_text!!.setTextColor(color)
    }

    fun setRight(s: String) {
        mRightTextContent = s
        setupViews()
    }
}
