package com.ydl.ydlcommon.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.widget.RelativeLayout;


import com.ydl.ydlcommon.R;

import java.util.List;


public class ListNoCancelDialog extends Dialog {

    private Context mContext;

    public ListNoCancelDialog(Context context) {
        super(context);
        mContext = context;
    }

    public ListNoCancelDialog(Context context, int theme) {
        super(context, theme);
        mContext = context;
    }

    public static class Builder {
        //是否可以点击对话框外部
//		Boolean flag=true;
        private Context context; //上下文对象
        private List<String> mDatas;
        private View contentView; //对话框中间加载的其他布局界面
        private DialogListAdapter adapter;
        private int itemTextColor;

        public interface OnItemClickLister {
            void onItemClick(Dialog dialog, View view, int position);

            void onItemLongClick(Dialog dialog, View view, int position);
        }

        private ListNoCancelDialog.Builder.OnItemClickLister mOnItemClickLister;

        public Builder(Context context, List<String> mDatas,int itemTextColor) {
            this.context = context;
            this.mDatas=mDatas;
            this.itemTextColor=itemTextColor;
        }

        /**
         * 设置对话框界面
         *
         * @param v View
         * @return
         */
        public Builder setContentView(View v) {
            this.contentView = v;
            return this;
        }

        public ListNoCancelDialog.Builder SetOnItemClickLister(ListNoCancelDialog.Builder.OnItemClickLister lister) {
            this.mOnItemClickLister = lister;
            return this;
        }





        public ListNoCancelDialog create() {
            LayoutInflater inflater = (LayoutInflater) context
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            // instantiate the dialog with the custom Theme
            final ListNoCancelDialog dialog = new ListNoCancelDialog(context, R.style.platform_normaldialog_style);
            View layout;
            layout = inflater.inflate(R.layout.platform_dialog_list_no_cancle_layout, null);

            dialog.addContentView(layout, new LayoutParams(
                    LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));

            if (mDatas != null&&mDatas.size()>0) {
               RecyclerView dialog_list_rcv=(RecyclerView) layout.findViewById(R.id.dialog_list_rcv);
                if(adapter==null){
                    adapter=new DialogListAdapter(mDatas,itemTextColor,context);
                }else {
                    adapter.notifyDataSetChanged();
                }
                FullyLinearLayoutManager linearLayoutManager = new FullyLinearLayoutManager(context, FullyLinearLayoutManager.VERTICAL, false);
                dialog_list_rcv.setLayoutManager(linearLayoutManager);
                dialog_list_rcv.setAdapter(adapter);
                adapter.setOnItemClickLister(new DialogListAdapter.OnItemClickLister() {
                    @Override
                    public void onItemClick(final View view, final int position) {
                        if (mOnItemClickLister != null) {
                            mOnItemClickLister.onItemClick(dialog,view,position);
//                                       itemClickLister.onClick(dialog,
//                                               DialogInterface.BUTTON_POSITIVE);
                        }
;
                    }

                    @Override
                    public void onItemLongClick(View view, int position) {
                        if (mOnItemClickLister != null) {
                            mOnItemClickLister.onItemLongClick(dialog,view,position);
                        }

                    }
                });
            } else if (contentView != null) {
                // if no message set
                // add the lceContentView to the dialog body
                ((RelativeLayout) layout.findViewById(R.id.message_layout)).removeAllViews();
                ((RelativeLayout) layout.findViewById(R.id.message_layout)).addView(
                        contentView, new LayoutParams(
                                LayoutParams.WRAP_CONTENT,
                                LayoutParams.WRAP_CONTENT));

            } else {
                ((RecyclerView) layout.findViewById(R.id.dialog_list_rcv)).setVisibility(View.GONE);
            }
            dialog.setContentView(layout);
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }

    }

    @Override
    public void show() {
        if (null == mContext){
            return;
        }
        if (mContext instanceof Activity){
            if (((Activity)mContext).isFinishing()){
                return;
            }
        }
        super.show();
    }
}
