package com.ydl.ydlcommon.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import androidx.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;

import com.ydl.ydlcommon.R;

/**
 * Created by jiucheng on 2018/7/13.
 * 功能：
 */

public class NoBindPhoneDialog extends Dialog {
    private Context context; //上下文对象
    private OnBindPhoneListener listener;

    public NoBindPhoneDialog(@NonNull Context context, OnBindPhoneListener listener) {
        super(context, R.style.platform_normaldialog_style);
        this.context = context;
        this.listener = listener;

        View view = LayoutInflater.from(context).inflate(R.layout.platform_dialog_no_bind_phone, null);
        RoundCornerButton bind = view.findViewById(R.id.btn_bind);
        bind.setOnClickListener(v -> {
            if (this.listener != null) {
                this.listener.bindPhone();
            }
            dismiss();
        });
        setContentView(view);
    }

    @Override
    public void show() {
        if (null == context){
            return;
        }
        if (context instanceof Activity){
            if (((Activity)context).isFinishing()){
                return;
            }
        }
        super.show();
        WindowManager.LayoutParams params = getWindow().getAttributes();
        params.width = ViewGroup.LayoutParams.MATCH_PARENT;
        params.height = ViewGroup.LayoutParams.WRAP_CONTENT;

        getWindow().getDecorView().setPadding(0, 0, 0, 0);

        getWindow().setAttributes(params);
    }

    public interface OnBindPhoneListener {
        void bindPhone();
    }
}
