package com.ydl.ydlcommon.view;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.ydlcommon.R;
import com.ydl.ydlcommon.utils.bitmap.BitmapUtils;
import com.yidianling.common.tools.RxImageTool;


/**
 * 头部title bar
 * Created by Dog on 2015/6/21.
 */
public class TitleBar extends RelativeLayout {

    //非激活时候的图标
    Drawable mLeftStartIcon, mLeftEndIcon, mRightStartIcon, mRightEndIcon, mRight;
    //判断三者是否激活
    boolean mIsLeftIconActive = false, mIsTitleIconActive = false, mIsRightIconActive = false;
    //颜色默认系统黑色
    int mTextColor, mSideTextColor;
    //底部线颜色
    int buttom_color;
    //左侧图标颜色
    int mLeftStartIconColor ;

    //文字内容
    String mLeftText, mTitle, mRightText;
    //接口部分
    OnTitleBarTextClick mLeftTextClick, mTitleTextClick, mRightTextClick, mRightImageClick;

    ImageView image;
    TextView tv_left_text;
    TextView tv_center_title;
    ImageView right_image;
    TextView tv_right_text;
    View iv_title_divide;

    public TitleBar(Context context) {
        super(context);
        View v = LayoutInflater.from(context).inflate(R.layout.platform_ui_title_bar, this);
        image = (ImageView) v.findViewById(R.id.image);
        tv_left_text = (TextView) v.findViewById(R.id.tv_left_text);
        tv_center_title = (TextView) findViewById(R.id.tv_center_title);
        right_image = (ImageView) v.findViewById(R.id.iv_right);
        tv_right_text = (TextView) v.findViewById(R.id.tv_right_text);
        iv_title_divide = v.findViewById(R.id.iv_title_divide);

        initRoot(null, 0);
        setupView();
    }

    public TitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        View v = LayoutInflater.from(context).inflate(R.layout.platform_ui_title_bar, this);
        image = (ImageView) v.findViewById(R.id.image);
        tv_left_text = (TextView) v.findViewById(R.id.tv_left_text);
        tv_center_title = (TextView) findViewById(R.id.tv_center_title);
        right_image = (ImageView) v.findViewById(R.id.iv_right);
        tv_right_text = (TextView) v.findViewById(R.id.tv_right_text);
        iv_title_divide = v.findViewById(R.id.iv_title_divide);

        initRoot(attrs, 0);
        setupView();
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View v = LayoutInflater.from(context).inflate(R.layout.platform_ui_title_bar, this);
        image = (ImageView) v.findViewById(R.id.image);
        tv_left_text = (TextView) v.findViewById(R.id.tv_left_text);
        tv_center_title = (TextView) findViewById(R.id.tv_center_title);
        right_image = (ImageView) v.findViewById(R.id.iv_right);
        tv_right_text = (TextView) v.findViewById(R.id.tv_right_text);
        iv_title_divide = v.findViewById(R.id.iv_title_divide);

        initRoot(attrs, defStyleAttr);
        setupView();
    }

    /**
     * 左侧文字点击事件
     */
    public void setOnLeftTextClick(OnTitleBarTextClick leftTextClick) {
        this.mLeftTextClick = leftTextClick;
    }

    /**
     * 中间文字点击事件
     */
    public void setOnTitleTextClick(OnTitleBarTextClick titleTextClick) {
        this.mTitleTextClick = titleTextClick;
    }


    /**
     * 右侧文字点击事件
     */
    public void setOnRightTextClick(OnTitleBarTextClick rightTextClick) {
        this.mRightTextClick = rightTextClick;
    }

    /**
     * 设置左侧字符
     *
     * @param mLeftText 内容
     */
    public void setmLeftText(String mLeftText) {
        if (TextUtils.isEmpty(mLeftText)) {
            tv_left_text.setVisibility(View.GONE);
            return;
        }
        this.mLeftText = mLeftText;
        tv_left_text.setText(mLeftText);
    }

    public void setLeftTextVisible(int state) {
        tv_left_text.setVisibility(state);
    }

    public void setDivideVisible(int visible) {
        iv_title_divide.setVisibility(visible);
    }

    /**
     * 设置头部text
     *
     * @param title 内容
     */
    public void setTitle(String title) {
        this.mTitle = title;
        tv_center_title.setText(title);
    }

    public String getTitle() {
        return mTitle;
    }

    /**
     * 设置右侧文字
     *
     * @param mRightText 内容
     */
    public void setmRightText(String mRightText) {
        this.mRightText = mRightText;
        tv_right_text.setText(mRightText);
    }

    /**
     * 设置右边文字显示状态
     */
    public void setRightTextVisiable(int visiable) {
        tv_right_text.setVisibility(visiable);
    }

    /**
     * 设置右侧字符颜色
     */
    public void setRightTextColor(int color) {
        tv_right_text.setTextColor(color);
    }

    public void setRightTextEnable(boolean enable) {
        tv_right_text.setEnabled(enable);
    }

    /**
     * 设置左侧字符颜色
     */
    public void setLeftTextColor(int color) {
        tv_left_text.setTextColor(color);
    }

    /**
     * 设置标题字符颜色
     */
    public void setTitleColor(int color) {
        tv_center_title.setTextColor(color);
    }


    void initRoot(AttributeSet attrs, int defStyleAttr) {
        final TypedArray a = getContext().obtainStyledAttributes(
                attrs, R.styleable.Platform_TitleBar, defStyleAttr, 0);

        mLeftText = a.getString(R.styleable.Platform_TitleBar_pa_left_text);
        mLeftStartIcon = a.getDrawable(R.styleable.Platform_TitleBar_pa_left_start_icon);
        mLeftEndIcon = a.getDrawable(R.styleable.Platform_TitleBar_pa_left_end_icon);
        mRight = a.getDrawable(R.styleable.Platform_TitleBar_pa_right_iv);

        mTitle = a.getString(R.styleable.Platform_TitleBar_pa_title_text);

        mRightText = a.getString(R.styleable.Platform_TitleBar_pa_right_text);
        mRightStartIcon = a.getDrawable(R.styleable.Platform_TitleBar_pa_right_start_icon);
        mRightEndIcon = a.getDrawable(R.styleable.Platform_TitleBar_pa_right_end_icon);

        mTextColor = a.getColor(R.styleable.Platform_TitleBar_pa_title_bar_text_color, 0xff3c3c3c);
        mSideTextColor = a.getColor(R.styleable.Platform_TitleBar_pa_side_text_color, 0xff3c3c3c);
        //底部线颜色
        buttom_color = a.getColor(R.styleable.Platform_TitleBar_pa_bm_line_color, getResources().getColor(R.color.platform_divide_color));

        //左侧图标颜色
        mLeftStartIconColor  = a.getColor(R.styleable.Platform_TitleBar_pa_left_start_icon_color, 0xffffff);

        a.recycle();
        setGravity(Gravity.CENTER_VERTICAL);
    }

    public void setLeftIcon(Drawable left) {
        tv_left_text.setCompoundDrawablesWithIntrinsicBounds(left, null, mLeftEndIcon, null);

    }

    public void setDivideBg(int color) {
        iv_title_divide.setBackgroundColor(color);
    }

    //设置左边距
    public void setPaddingLeft(int padding_dp) {
        try {
            image.setPadding(RxImageTool.dp2px(padding_dp), 0, 0, 0);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setupView() {
        //左侧部分
        tv_left_text.setText(mLeftText);
        tv_left_text.setTextColor(mSideTextColor);
        tv_left_text.setCompoundDrawablesWithIntrinsicBounds(getLeftStartIcon(), null, mLeftEndIcon, null);
        //中间部分
        tv_center_title.setText(mTitle);
        tv_center_title.setTextColor(mTextColor);
        //右侧部分
        right_image.setImageDrawable(mRight);
        tv_right_text.setText(mRightText);
        tv_right_text.setTextColor(mSideTextColor);
        tv_right_text.setCompoundDrawablesWithIntrinsicBounds(mRightStartIcon, null, mRightEndIcon, null);
        //背景色

        //底部线
        iv_title_divide.setBackgroundColor(buttom_color);

        //设置点击事件
        setupTextClick();

    }

    Drawable getLeftStartIcon(){
        if(mLeftStartIconColor != 0xffffff && mLeftStartIcon == null) {
            //动态设置返回图标颜色
            Resources resources = this.getResources();
            Bitmap bmp = BitmapFactory.decodeResource(resources, R.drawable.platform_common_back);
            Bitmap colorBmp = BitmapUtils.tintBitmap(bmp, mLeftStartIconColor);
            return new BitmapDrawable(resources, colorBmp);
        }else {
            return mLeftStartIcon;
        }
    }

    public void setDivideHidden(boolean hide) {
        if (hide) {
            iv_title_divide.setVisibility(View.GONE);
        } else {
            iv_title_divide.setVisibility(View.VISIBLE);
        }

    }

    /**
     * 设置文字点击事件
     */
    void setupTextClick() {
        tv_left_text.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mIsLeftIconActive = !mIsLeftIconActive;
                if (mLeftTextClick != null) {
                    mLeftTextClick.onClick(tv_left_text, mIsLeftIconActive);
                } else {
                    //默认退出activity
                    Context context = getContext();
                    if (context instanceof Activity) {
                        ((Activity) context).finish();
                    }
                }
            }
        });


        tv_center_title.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mIsTitleIconActive = !mIsTitleIconActive;
                if (mTitleTextClick != null) {
                    mTitleTextClick.onClick(tv_center_title, mIsTitleIconActive);
                }
            }
        });

        tv_right_text.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mIsRightIconActive = !mIsRightIconActive;
                if (mRightTextClick != null) {
                    mRightTextClick.onClick(tv_right_text, mIsRightIconActive);
                }
            }
        });

        right_image.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mRightImageClick != null) {
                    mRightImageClick.onClick(v, true);
                }
            }
        });

    }

    //左侧返回按钮
    public void setLeftListener(View.OnClickListener listener) {
        tv_left_text.setOnClickListener(listener);
    }

    public interface OnTitleBarTextClick {
        /**
         * title bar文字点击事件
         *
         * @param view     被点击的view
         * @param isActive 是否是激活状态
         */
        void onClick(View view, boolean isActive);
    }

    public void setRightIcon(Drawable rightIcon) {

        mRightStartIcon = rightIcon;
        tv_right_text.setCompoundDrawablesWithIntrinsicBounds(mRightStartIcon, null, mRightEndIcon, null);
    }

    public void setImage(Drawable image_) {
        image.setImageDrawable(image_);
    }

    public void setImageVis(int vis) {
        switch (vis) {
            case 0:
                image.setVisibility(GONE);
                break;
            default:
                image.setVisibility(VISIBLE);
        }
    }

    public void setImage_right(Drawable right) {
        right_image.setImageDrawable(right);
    }

    public void setRightImageListener(View.OnClickListener listener) {
        right_image.setOnClickListener(listener);
    }

    public void setRightImageIfNoSee() {
        RelativeLayout.LayoutParams layoutParams = (LayoutParams) right_image.getLayoutParams();
        layoutParams.rightMargin = 0;
        right_image.setLayoutParams(layoutParams);
    }

    public void setRightImageIfShouldSee() {

        RelativeLayout.LayoutParams layoutParams = (LayoutParams) right_image.getLayoutParams();
        layoutParams.leftMargin = 30;
        right_image.setLayoutParams(layoutParams);
    }

    public void setLeftImageListener(OnClickListener listener) {
        tv_left_text.setOnClickListener(listener);
    }

    public void setImageListener(OnClickListener listener) {
        image.setOnClickListener(listener);
    }

    public void setmRightImageClick(OnTitleBarTextClick mRightImageClick) {
        this.mRightImageClick = mRightImageClick;
    }
    public void setRightImageVisibility(int visible){
        right_image.setVisibility(visible);
    }
}
