package com.ydl.ydlcommon.view;

import android.content.Context;
import androidx.core.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.MotionEvent;

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/7/8
 */
public class UpScrollNestedScrollView extends NestedScrollView {
    private boolean mIsWebViewOnTop = true;
    private boolean mIsOthersLayoutShow = true;
    private float mDownY;

    public UpScrollNestedScrollView(Context context) {
        super(context);
    }

    public UpScrollNestedScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public UpScrollNestedScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        float y = ev.getY();
        switch (ev.getAction()) {
            case MotionEvent.ACTION_DOWN:
                mDownY = y;
                break;
            case MotionEvent.ACTION_MOVE:
                float dy = y - mDownY;
                if (dy > 0) { // 手指向下滑
                    if (!mIsWebViewOnTop) {
                        return false; // 网页没到顶部，不拦截事件
                    }
                } else { // 手指向上滑
                    if (!mIsOthersLayoutShow) {
                        return false; // 顶部原生layout完全隐藏，不拦截事件
                    }
                }
                break;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setIsWebViewOnTop(boolean onTop) {
        this.mIsWebViewOnTop = onTop;
    }

    public void setIsOthersLayoutShow(boolean isOthersLayoutShow) {
        this.mIsOthersLayoutShow = isOthersLayoutShow;
    }
}
