package com.ydl.ydlcommon.view.swapelayout

import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import com.ydl.ydlcommon.R
import kotlinx.android.synthetic.main.platform_swipelayout_item_load_more.view.*


/**
 * @author yuanwai
 * @描述:上拉加载更多适配器
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/26
 */
class YDLAdapterWrapper(private val mAdapter: RecyclerView.Adapter<RecyclerView.ViewHolder>) : RecyclerView.Adapter<RecyclerView.ViewHolder>() ,View.OnClickListener{

    private var mShowLoadItem = true

    private var mWrapperHolder: WrapperHolder? = null

    private var mAdapterType =
        ADAPTER_TYPE_LINEAR

    private var mSpanCount: Int = 0


    private var STATUS_FOOTER : Int = 1

    private var uiText : String? = ""

    private var uiDrawable : Int? = 0
    /**
     * footer回调
     */
    private var mFooterCallBack: FooterCallBack? = null



    /** 设置Wrapper的类型, 默认是线性的  */
    fun setAdapterType(type: Int) {
        if (mAdapterType != type) {
            mAdapterType = type
        }
    }

    /** 网格布局的网格数量  */
    fun setSpanCount(count: Int) {
        if (count != mSpanCount) {
            mSpanCount = count
        }
    }

    fun setUIText(uiText : String){
        this.uiText = uiText
    }

    fun setUIDrawable(drawable : Int){
        this.uiDrawable = drawable
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        if (viewType == ITEM_TYPE_LOAD) {
            if (mWrapperHolder == null) {
                val view = View.inflate(parent.context, R.layout.platform_swipelayout_item_load_more, null)
                view.setOnClickListener(this)
                mWrapperHolder = WrapperHolder(view)
            }
            return mWrapperHolder as WrapperHolder
        } else {
            return mAdapter.onCreateViewHolder(parent, viewType)
        }
    }

    // 允许显示"加载更多"item, 并且position为末尾时,拦截
    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        if (mShowLoadItem && position == itemCount - 1) {
            // 最后一项 不需要做什么额外的事
        } else if (position < mAdapter.itemCount) {
            // 正常情况
            if (holder is WrapperHolder && null != holder.itemView){
                holder.itemView.visibility = View.VISIBLE
            }
            mAdapter.onBindViewHolder(holder, position)
        } else {
            // 网格的补空的情况
            if (holder is WrapperHolder && null != holder.itemView) {
                holder.itemView.visibility = View.INVISIBLE
            }
        }
    }

    fun refresh(){
        mAdapter.notifyDataSetChanged()
    }

    override fun getItemCount(): Int {
        if (mAdapterType == ADAPTER_TYPE_LINEAR) {
            // 线性布局
            return if (mShowLoadItem) mAdapter.itemCount + 1 else mAdapter.itemCount
        } else {
            // 网格布局
            if (!mShowLoadItem)
                return mAdapter.itemCount// 不显示load more时直接返回真实数量
            val remain = mAdapter.itemCount % mSpanCount // 余数
            return if (remain == 0) {
                mAdapter.itemCount + 1
            } else mAdapter.itemCount + 1 + (mSpanCount - remain)
            // 余数不为0时,先凑满再加1
        }
    }

    override fun getItemViewType(position: Int): Int {
        // 当显示"加载更多"条目, 并且位置是最后一个时, wrapper进行拦截
        return if (mShowLoadItem && position == itemCount - 1) {
            ITEM_TYPE_LOAD// 注意要避免和原生adapter返回值重复
        } else mAdapter.getItemViewType(position)
        // 其他情况交给原生adapter处理
    }

    fun setLoadItemVisibility(isShow: Boolean) {
        if (mShowLoadItem != isShow) {
            mShowLoadItem = isShow
            notifyDataSetChanged()
        }
    }

    fun setLoadItemState(status: Int) {
        STATUS_FOOTER = status
        when(status){
            IYDLSwipeConfig.STATUS_UP_LOAD -> {
                mWrapperHolder?.setLoadText("上拉加载更多")
                mWrapperHolder?.setNullDrawable()
                mWrapperHolder?.setLoadPbVisibility(false)
            }
            IYDLSwipeConfig.STATUS_LOADING -> {
                mWrapperHolder?.setLoadText("正在加载...")
                mWrapperHolder?.setNullDrawable()
                mWrapperHolder?.setLoadPbVisibility(true)
            }
            IYDLSwipeConfig.STATUS_UI -> {
                mWrapperHolder?.setLoadText("没有更多数据...")
                mWrapperHolder?.setNullDrawable()
                mWrapperHolder?.setLoadPbVisibility(false)
            }
        }
    }

    inner class WrapperHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        fun setLoadText(text: CharSequence) {
            itemView.item_load_tv?.text = text
        }

        fun setMoreDrawable(){
            val drawable = itemView.context.resources.getDrawable(uiDrawable!!)
            /// 这一步必须要做,否则不会显示.
            drawable.setBounds(0, 0, drawable.minimumWidth, drawable.minimumHeight)
            itemView.item_load_tv.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable, null)
        }

        fun setNullDrawable(){
            itemView.item_load_tv.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null)
        }

        fun setLoadPbVisibility(show: Boolean) {
            itemView.item_load_pb?.visibility = if (show) View.VISIBLE else View.GONE
        }
    }

    companion object {
        /** 线性  */
        val ADAPTER_TYPE_LINEAR = 0x01
        /** 网格  */
        val ADAPTER_TYPE_GRID = 0x02
        /** view type : "上拉加载更多"  */
        private val ITEM_TYPE_LOAD = Integer.MAX_VALUE / 2
    }

    override fun onClick(v: View?) {
        if (IYDLSwipeConfig.STATUS_UI == STATUS_FOOTER){
            mFooterCallBack?.click()
        }
    }

    /**
     * 设置底部footer点击回调
     */
    fun setFooterCallBack(footerCallBack: FooterCallBack){
        mFooterCallBack = footerCallBack
    }
    /**
     * 底部footer点击回调
     */
    interface FooterCallBack{
        /**
         * 点击回调
         */
        fun click()
    }
}