package com.ydl.webview

import android.app.Activity
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.LinearLayout
import com.daimajia.androidanimations.library.Techniques
import com.daimajia.androidanimations.library.YoYo

import kotlinx.android.synthetic.main.web_ui_private_safe_hint.view.*


/**
 * 设置手势密码或开启指纹登录提醒
 * Created by zqk on 17-11-6.
 */

class SafeTipView : LinearLayout {

    var location: String? = null //放置的页面，用于统计不同页面的点击事件

    constructor(context: Context) : super(context) {
        initView()
    }

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
        initView()
    }

    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        initView()
    }

    fun initView() {
        this.orientation = HORIZONTAL
        this.background = ColorDrawable(Color.parseColor("#fff7e5"))
        LayoutInflater.from(context).inflate(R.layout.platform_ui_private_safe_hint, this, true)
        btnClose.setOnClickListener {
            YoYo.with(Techniques.FadeOut)
                    .duration(400)
                    .onEnd { visibility = View.GONE }
                    .playOn(this@SafeTipView)
            WebModularServiceUtils.getUserService().setTrendsSafeTip(true)
        }
        tvTip.setOnClickListener {
            WebModularServiceUtils.getUserService().privacyIntent(context as Activity)
        }
    }

    fun updateVisibility() {
        if (WebModularServiceUtils.getUserService().safeTipViewGone()) {
            this.visibility = View.GONE
        } else {
            this.visibility = View.VISIBLE
        }
    }

}
