package com.yidianling.im.api.bean

import android.os.Parcel
import android.os.Parcelable

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/05/04
 */
data class ReceiveRedPacketParam(
        var status: Int = 0,
        var money: String? = null,
        var name: String? = null,
        var headUrl: String? = null,
        var expertUrl: String? = null,
        var expertName: String? = null,
        var expertTime: String? = null) : Parcelable {
    constructor(parcel: Parcel) : this(
            parcel.readInt(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString()) {
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeInt(status)
        parcel.writeString(money)
        parcel.writeString(name)
        parcel.writeString(headUrl)
        parcel.writeString(expertUrl)
        parcel.writeString(expertName)
        parcel.writeString(expertTime)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<ReceiveRedPacketParam> {
        override fun createFromParcel(parcel: Parcel): ReceiveRedPacketParam {
            return ReceiveRedPacketParam(parcel)
        }

        override fun newArray(size: Int): Array<ReceiveRedPacketParam?> {
            return arrayOfNulls(size)
        }
    }
}