package com.yidianling.user.api.utils

import com.alibaba.android.arouter.exception.NoRouteFoundException
import com.alibaba.android.arouter.facade.template.IProvider
import com.alibaba.android.arouter.launcher.ARouter
import com.yidianling.user.api.service.IUserService


/**
 * Created by haorui on 2019-09-21 .
 * Des:查找 Arouter 服务封装类
 */
object UserApiServiceUtils {

    private val routerMap: HashMap<String, IProvider> = HashMap()

    fun provideUserApiService(): IUserService {
        return provide(IUserService::class.java)
    }

    private fun <T : IProvider> provide(clz: Class<T>): T {

        var provider: IProvider? = null
        val simpleName = clz.simpleName;

        if (routerMap[simpleName]!=null){
            return routerMap[simpleName] as T
        }

        try {
            provider = ARouter.getInstance().navigation(clz)
            if (provider == null){
                throw NoRouteFoundException("Please check if you are dependent on the module containing $simpleName")
            }
            routerMap[simpleName] = provider
        } catch (e: Exception) {
            System.out.print(e.message)
        }

        return provider as T
    }
}