package com.ydl.component

import android.os.Bundle
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentPagerAdapter
import androidx.appcompat.app.AppCompatActivity
import com.yidianling.consultant.ExpertSearchFragment
import com.yidianling.dynamic.trendsHome.TrendsHomeFragment
import com.yidianling.home.ui.fragment.YdlHomeFragment
import com.yidianling.user.mine.MineFragment
import kotlinx.android.synthetic.main.activity_test_app.*
import java.util.*

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2020/1/14
 */
class TestAppActivity : AppCompatActivity() {
    private var fragments: ArrayList<Fragment> =
        ArrayList()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_test_app)

        fragments.add(YdlHomeFragment())
        fragments.add(ExpertSearchFragment())
        fragments.add(TrendsHomeFragment().setTab("trend_tap"))
        fragments.add(MineFragment())
        val adapter: FragmentPagerAdapter =
            object : FragmentPagerAdapter(supportFragmentManager) {
                override fun getItem(position: Int): Fragment {
                    return fragments.get(position)
                }

                override fun getCount(): Int {
                    return fragments.size
                }
            }

        view_page.adapter = adapter
        view_page.offscreenPageLimit = 2
    }
}