package com.ydl.component.mvp

import androidx.lifecycle.Lifecycle
import androidx.lifecycle.OnLifecycleEvent
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import com.ydl.component.api.DemoService
import com.ydl.component.model.HomeFMBean
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.mvp.base.BaseModel
import com.ydl.ydlnet.YDLHttpUtils
import io.reactivex.Observable

/**
 * Created by haorui on 2019-09-01 .
 * Des:
 */
class DemoModel : BaseModel(), DemoContract.Model {
    override fun getFmMusic(): Observable<HomeFMBean> {
        return YDLHttpUtils.obtainApi(DemoService::class.java)
            .getFMData()
            .compose(RxUtils.resultJavaData())
    }

    override fun getHome(): Observable<JsonObject> {
        return YDLHttpUtils.obtainApi(DemoService::class.java)
            .getHomeData()
    }

    override fun getUser(): Observable<JsonArray> {
        return YDLHttpUtils.obtainApi(DemoService::class.java)
            .getUsers(1, 10)
            //使用接口缓存
//            .compose(YDLHttpUtils.transformCache("users"))
    }

    @OnLifecycleEvent(Lifecycle.Event.ON_PAUSE)
    internal fun onPause() {

    }
}
