package http

import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import data.ArticleCategoryListBean
import data.ArticleListBean
import io.reactivex.Observable
import retrofit2.http.GET
import retrofit2.http.Headers
import retrofit2.http.Query

interface ArticleApi {

    //文章标签
    @GET("newArticle/ArticleCate")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getArticleTagList(): Observable<BaseAPIResponse<ArticleCategoryListBean>>

    //文章列表
    @GET("newArticle/list/all")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getArticleList(
        @Query("perPageRows") perPageRows: Int = 10,
        @Query("page") page: Int = 1,
        @Query("tagId") tagId: Int = 0
    ): Observable<BaseAPIResponse<ArticleListBean>>

    //文章列表  推荐列表
    @GET("newArticle/list/recommend")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getRecommendArticleList(
        @Query("perPageRows") perPageRows: Int = 10,
        @Query("page") page: Int = 1
    ): Observable<BaseAPIResponse<ArticleListBean>>

}