package http

import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlnet.YDLHttpUtils
import data.ArticleCategoryListBean
import data.ArticleListBean
import io.reactivex.Observable

class ArticleHttp {

    companion object{
        fun getInstance() = Holder.INSTANCE
    }

    object Holder{
        val INSTANCE = ArticleHttp()
    }

    private var articleApi:ArticleApi?=null

    private fun getArticleApi():ArticleApi{
        if (articleApi == null){
            articleApi = YDLHttpUtils.obtainApi(ArticleApi::class.java)
        }
        return articleApi!!
    }

    fun getArticleCategoryList():Observable<BaseAPIResponse<ArticleCategoryListBean>>{
        return getArticleApi().getArticleTagList()
    }

    fun getRecommendArticleList(perPageRows:Int,page:Int):Observable<BaseAPIResponse<ArticleListBean>>{
        return getArticleApi().getRecommendArticleList(perPageRows = perPageRows,page = page)
    }

    fun getArticleList(perPageRows:Int,page:Int,tagId:Int):Observable<BaseAPIResponse<ArticleListBean>>{
        return getArticleApi().getArticleList(perPageRows = perPageRows,page = page,tagId = tagId)
    }


}