package com.ydl.audioim.http

import com.ydl.audioim.bean.AgoraTokenResponse
import com.ydl.audioim.bean.CallCheckBean
import com.ydl.audioim.bean.ConnectBean
import com.ydl.consultantim.bean.ListenTokenBean
import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import io.reactivex.Observable
import okhttp3.RequestBody
import retrofit2.http.*

/**
 * @author jiucheng
 * @描述:声网业务接口api
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/9
 */
interface AudioNetAPi {

    @GET("counselor/consultationCall/queryCallInfo")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun checkCall(@Query("calleeUid") calleeUid: String?): Observable<BaseAPIResponse<CallCheckBean>>
    /**
     * 通话开始回调
     */
//    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA,"Content-Type:application/json")
//    @POST("auth/listen-order/callback/agora/start")
//    fun connectStart(@Body body:RequestBody): Observable<BaseAPIResponse<Any>>

    /**
     * 通话结束回调
     */
//    @Headers( YDL_DOMAIN + YDL_DOMAIN_JAVA,"Content-Type:application/json")
//    @POST("auth/listen-order/callback/agora/finish")
//    fun connectFinish(@Body body:RequestBody): Observable<BaseAPIResponse<Any>>

    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @POST("counselor/device/upload")
    fun report(@Body params: Map<String, @JvmSuppressWildcards Any>): Observable<BaseAPIResponse<String>>

    /**
     * 通话警告与错误回调
     */
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @POST("auth/listen-order/callback/agora")
    fun connectException(@Body body: RequestBody): Observable<BaseAPIResponse<Any>>


    /**
     * 链接 ：获取axb手机号
     */
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA,"Content-Type:application/json")
    @GET("auth/listen/dial")
    fun connectListen(@QueryMap params: Map<String, String>): Observable<BaseAPIResponse<ConnectBean>>

    /**
     *通知服务端发送推送
     */
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA,"Content-Type:application/json")
    @POST("push/notify/doctor")
    fun noticeServerPush(@Body body: RequestBody): Observable<BaseResponse<Any>>

    /**
     * 获取声网登录token
     */
    @Headers( YDL_DOMAIN + YDL_DOMAIN_JAVA,"Content-Type:application/json")
    @GET("im/getAgoraToken")
    fun getAgoraToken(): Observable<BaseAPIResponse<AgoraTokenResponse>>


    //获取token
    @FormUrlEncoded
    @POST("listen/token")
    fun listenToken(@FieldMap map: Map<String, String>): Observable<BaseResponse<ListenTokenBean>>


//    @GET("message/call-end/agora")
//    @Headers( YDL_DOMAIN + YDL_DOMAIN_JAVA)
//    fun callEndStatusUpdate(@Query("channelId") channelId:String,@Query("endStatus") endStatus:Int,@Query("msg") msg:String): Observable<BaseAPIResponse<Any>>

    //倾诉事件上报接口
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA, "Content-Type:application/json")
    @POST("call/v1/event/save")
    fun callEventSave(@Body body: RequestBody): Observable<BaseAPIResponse<Any>>
}