package com.ydl.audioim.model

import com.ydl.audioim.bean.ConnectBean
import com.ydl.audioim.contract.IAudioHomeActivityContract
import com.ydl.audioim.http.AudioApiRequestUtil
import com.ydl.audioim.http.command.*
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import io.reactivex.Observable

/**
 * @author jiucheng
 * @描述:model实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/10/30
 */
class AudioHomeModelImpl : IAudioHomeActivityContract.Model {
//    override fun connectStart(param: ConnectStartCommand): Observable<BaseAPIResponse<Any>> {
//        return AudioApiRequestUtil.connectStart(param)
//    }
//
//    override fun connectFinish(param: ConnectFinishCommand): Observable<BaseAPIResponse<Any>> {
//        return AudioApiRequestUtil.connectFinish(param)
//    }

    override fun connectException(param: ConnectExceptionCommand): Observable<BaseAPIResponse<Any>> {
        return AudioApiRequestUtil.connectException(param)
    }

    override fun noticeServerPush(param: NoticePushCommand): Observable<BaseResponse<Any>> {
        return AudioApiRequestUtil.noticeServerPush(param)
    }

    override fun getAXBPhone(cmd: ConnectCommand): Observable<BaseAPIResponse<ConnectBean>> {
        return AudioApiRequestUtil.connectListen(cmd)
    }
}