package com.ydl.audioim.widget

import android.app.Activity
import android.app.Dialog
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.widget.TextView
import com.ydl.audioim.R
import kotlinx.android.synthetic.main.audioim_dialog_axb_confirm.*

/**
 * @author jiucheng
 * @描述:Axb呼叫确认弹窗
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/27
 */
class AxbConfirmDialog : Dialog {
    private var activity: Activity? = null
    private var listener: OnClickEnsureListener? = null
    private var type :Int = 1 //弹窗类型，1为手动切换axb布局，2为自动切换axb布局，3权限拒绝

    constructor(activity: Activity?,type:Int, listener: OnClickEnsureListener?) : super(activity) {
        this.activity = activity
        this.listener = listener
        this.type = type
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if (this.type==2){
            setContentView(R.layout.audioim_dialog_autoaxb_confirm)
        } else if (this.type == 3) {
            setContentView(R.layout.audioim_dialog_autoaxb_confirm)
            findViewById<TextView>(R.id.tvTip).text = "您未授权无法使用网络通话\n请点击呼叫使用传统电话"
        } else {
            setContentView(R.layout.audioim_dialog_axb_confirm)
        }

        setCanceledOnTouchOutside(false)
        setCancelable(false)
        window.setBackgroundDrawable(ColorDrawable())
        ic_close.setOnClickListener {
            listener?.onClose()
            dismiss()
        }

        rl_ensure.setOnClickListener {
            listener?.onClickEnsure()
            dismiss()
        }
    }

    interface OnClickEnsureListener {
        fun onClickEnsure()
        fun onClose()
    }

    override fun show() {
        if (null == activity || activity!!.isFinishing) {
            return
        }
        super.show()
    }
}