package com.ydl.consultantim.contract

import com.ydl.ydl_av.chat.bean.AudioMessageBean
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView

/**
 * @author jiucheng
 * @描述:声网倾诉首页约束类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/10/30
 */
interface IConsultantAudioHomeActivityContract {

    interface View : IView {
        fun listenStatusPushResponse()

        fun channelTokenResponse(token: String?,needJoinChannel: Boolean)

        // 执行接听操作
        // canExcute是否执行
        fun executeCall(canExcute: Boolean)

        // 关闭当前页面，并提示用户已挂断
        fun executeFinish()
    }


    interface Presenter : IPresenter<View> {
        /**
         * 通话开始（更新专家状态）
         * @param param 请求参数
         * @param isSwitchAxb 是否切换axb
         */
//        fun connectStart(param: ConnectStartCommand)

        /**
         * 通话结束（更新专家状态）
         * @param param 请求参数
         * @param isSwitchAxb 是否切换axb
         */
//        fun connectFinish(param: ConnectFinishCommand)

        /**
         * 获取频道token
         *
         */
        fun getChannelToken(mAudioMessageBean: AudioMessageBean?, needJoinChannel: Boolean = true)

        /**
         * 判断用户是否在频道中
         */
        fun userIsInChannel(channelName: String, agoraUid: String)
    }


    interface Model : IModel {
        /**
         * 通话开始回调（更新专家状态）
         */
//        fun connectStart(param: ConnectStartCommand)

        /**
         * 通话结束（更新专家状态）
         */
//        fun connectFinish(param: ConnectFinishCommand)
    }
}
