package com.ydl.confide.home.contract

import android.content.Context
import com.ydl.confide.home.bean.ConfideHomeBodyBean
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.http.ConfideRecommendParam
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.ydl.ydlcommon.mvp.lce.ILceView
import com.ydl.ydlcommon.view.DrawableRightTextView
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:倾诉首页约束类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10
 */
interface IConfideHomeContract{
    //View接口
    interface View : IView,ILceView {

        /**
         * 倾诉首页数据请求结果
         * @param list 数据集合
         */
        fun confideHomeResponse(list : MutableList<ConfideHomeDataBean>)

        /**
         * 倾诉首页数据请求失败
         */
        fun confideHomeRequestFail()

        /**
         * 为你推荐--筛选 请求结果
         */
        fun recommendListResponse(bean : ConfideHomeDataBean)

        /**
         * 为你推荐--翻页 请求结果
         */
        fun recommendListMoreResponse(bean : ConfideHomeDataBean)

        /**
         * 更新section的播放状态
         * 点击列表中的一个播放按钮 其他播放按钮要显示暂停状态
         * @param type
         * @param index 模块中点击播放的索引位置
         * @param recommendId
         */
        fun updataPlayStatu(type : Int?,index : Int,recommendId : Int,isPlaying : Boolean)

        /**
         * 为你推荐列表
         */
        fun recommendList(page : Int)
        /**
         * 排序弹窗
         */
        fun showSortPopupWindow(v_line_top: android.view.View, tvSort: DrawableRightTextView, bodyBean: ConfideHomeBodyBean?)

        /**
         * 性别年龄弹窗
         */
        fun showSexAgePopupWindow(v_line_top: android.view.View, tvSexAge: DrawableRightTextView, bodyBean: ConfideHomeBodyBean?)

        /**
         * 擅长方向弹窗
         */
        fun showGoodPopupWindow(v_line_top: android.view.View, tvGood: DrawableRightTextView, bodyBean: ConfideHomeBodyBean?)

        /**
         * 移动到为你推荐筛选模块 并置顶
         */
        fun moveToFilter()
        /**
         * 显示错误信息
         */
        fun showError1(msg : String?)

        fun getContext() : Context

        fun showProgress()
    }

    interface Presenter : IPresenter<View> {
        /**
         * 倾诉首页数据请求
         */
        fun confideHomeRequest(isRefresh:Boolean = true)

        /**
         * 为你推荐列表（筛选调用）
         */
        fun recommendList(param : ConfideRecommendParam)
        /**
         * 为你推荐列表(翻页调用)
         */
        fun recommendListMore(param : ConfideRecommendParam)
    }

    interface Model: IModel {
        /**
         * 倾诉首页数据请求
         */
        fun confideHomeRequest() : Observable<MutableList<ConfideHomeDataBean>>

        /**
         * 为你推荐列表
         */
        fun recommendList(param : ConfideRecommendParam) : Observable<ConfideHomeDataBean>
    }
}