package com.ydl.confide.home.listener

import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.ydl.confide.home.widget.ConfideHomeFilterView
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.RxImageTool

/**
 * @author yuanwai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/25
 */
class ConfideHomeRecycleViewListener() : RecyclerView.OnScrollListener() {
    /**
     * 筛选模块位置
     */
    private var mIndex: Int = 0
    /**
     * rv是否需要第二次滚动
     */
    private var move = false

    private lateinit var listener: HideScrollListener

    private var visible = true

    constructor(listener: HideScrollListener):this(){
        this.listener = listener
    }


    override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
        super.onScrolled(recyclerView, dx, dy)
        //在这里进行第二次滚动（最后的距离）
        if (move) {
            move = false
            //获取要置顶的项在当前屏幕的位置，mIndex是记录的要置顶项在RecyclerView中的位置
            var n = mIndex - (recyclerView!!.layoutManager as LinearLayoutManager).findFirstVisibleItemPosition()
            if (0 <= n && n < recyclerView.childCount) {
                //获取要置顶的项顶部离RecyclerView顶部的距离
                var top = recyclerView.getChildAt(n).top
                //最后的移动
                recyclerView.scrollBy(0, top)
            }
        }

        if (dy > 0 && visible) {
            visible = false
            listener.onHide()
        } else if (dy < 0 && !visible) {
            visible = true
            listener.onShow()
        }

    }

    /**
     * 设置筛选模块的位置
     */
    fun setFilterIndex(index : Int){
        this.mIndex = index
    }

    /**
     * 移动筛选模块置顶
     */
    fun moveToPosition(mRecyclerView: RecyclerView){

        mRecyclerView.scrollBy(0, 1)
        val childAt = mRecyclerView.getChildAt(mIndex)
        if (childAt !is ConfideHomeFilterView) return
        val top = childAt.top - childAt.height
        if(top==0 || top==1){
            //已滚动到顶部

        }else{
//            top-=mRecyclerView.getChildAt(mIndex).height

            mRecyclerView.scrollBy(0, top)
        }

        //获取当前recycleView屏幕可见的第一项和最后一项的Position
//        var firstItem = (recyclerview.layoutManager as LinearLayoutManager).findFirstVisibleItemPosition()
//        var lastItem = (recyclerview.layoutManager as LinearLayoutManager).findLastVisibleItemPosition()
//        //然后区分情况
//        if (mIndex <= firstItem) {
//            //当要置顶的项在当前显示的第一个项的前面时
//            recyclerview.scrollToPosition(mIndex)
//        } else if (mIndex <= lastItem) {
//            //当要置顶的项已经在屏幕上显示时，计算它离屏幕原点的距离
//            var top = recyclerview.getChildAt(mIndex - firstItem).top - RxImageTool.dip2px(48f)
//            recyclerview.scrollBy(0, top)
//        } else {
//            //当要置顶的项在当前显示的最后一项的后面时
//            recyclerview.scrollToPosition(mIndex)
//            //记录当前需要在RecyclerView滚动监听里面继续第二次滚动
//            move = true
//        }
    }


}