package com.ydl.confide.home.listener

import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.util.Log
import android.view.View
import android.widget.EditText
import android.widget.ImageView
import android.widget.RelativeLayout
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.ydl.confide.R
import com.ydl.confide.home.adapter.ConfideHomeAdapter
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.widget.ConfideHomeFilterView
import com.ydl.ydlcommon.base.BaseActivityMgr
import com.ydl.ydlcommon.utils.KeyboardChangeListener
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.RxImageTool

/**
 * @author yuanwai
 * @描述:悬浮按钮监听事件
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/25
 */
class ConfideHomeRecyleSuspendListener : RecyclerView.OnScrollListener() {

    private var mCurrentPosition = 0

    private var mSuspensionHeight: Int = RxImageTool.dip2px(48f)

    private var mSearchViewHeight: Int = RxImageTool.dip2px(48f)

    private var filterView: ConfideHomeFilterView? = null
    private var searchView: RelativeLayout? = null
    private var divView: View? = null

    private var searchText = ""

    private var adapter: ConfideHomeAdapter? = null

    fun setFilterView(filterView: ConfideHomeFilterView, divView: View) {
        this.filterView = filterView
        this.divView = divView
    }

    fun setFilterView(
        filterView: ConfideHomeFilterView,
        searchView: RelativeLayout,
        divView: View
    ) {
        this.filterView = filterView
        this.divView = divView
        this.searchView = searchView

    }

    fun setSectionAdapter(adapter: ConfideHomeAdapter) {
        this.adapter = adapter
    }

    override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
        super.onScrollStateChanged(recyclerView, newState)
        if (null != filterView) {
            mSuspensionHeight = filterView!!.height
        }

        if (searchView != null) {
            mSearchViewHeight = searchView!!.height
        }

    }

    override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
        super.onScrolled(recyclerView, dx, dy)
        if (null == adapter) {
            return
        }
        val manager = recyclerView!!.layoutManager as LinearLayoutManager

        val findFirstCompletelyVisibleItemPosition =
            manager.findFirstCompletelyVisibleItemPosition();

        if (findFirstCompletelyVisibleItemPosition != 0 && findFirstCompletelyVisibleItemPosition != 1) {
            searchView?.visibility = View.VISIBLE
        } else {
            searchView?.visibility = View.INVISIBLE
        }

        if (mCurrentPosition != manager.findFirstVisibleItemPosition()) {
            mCurrentPosition = manager.findFirstVisibleItemPosition()
        }

        LogUtil.e("http----------------type=" + adapter!!.getItemViewType(mCurrentPosition))
        if (adapter!!.getItemViewType(mCurrentPosition + 1) == IConfideHomeConfig.TYPE_RECOMMEND) {
            var view = manager.findViewByPosition(mCurrentPosition + 1)
            if (view != null) {
                if (view is ConfideHomeFilterView) {
                    if (view.top <= mSuspensionHeight) {
                        filterView!!.visibility = View.VISIBLE
                        divView?.visibility = View.VISIBLE
                    } else {
//                    filterView!!.visibility = View.INVISIBLE
                        filterView!!.visibility = View.INVISIBLE
                        divView?.visibility = View.INVISIBLE
                    }
                }
            }
        } else if (adapter!!.getItemViewType(mCurrentPosition + 1) == IConfideHomeConfig.TYPE_RECOMMEND || adapter!!.getItemViewType(
                mCurrentPosition + 1
            ) == IConfideHomeConfig.TYPE_SOUND
        ) {
            filterView!!.visibility = View.VISIBLE
            divView?.visibility = View.VISIBLE
        } else {
            filterView!!.visibility = View.INVISIBLE
            divView?.visibility = View.INVISIBLE
        }
    }
}