package com.ydl.confide.home.popwindow

import android.content.Context
import android.graphics.drawable.BitmapDrawable
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.PopupWindow
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeFiterItemBean
import com.ydl.confide.home.popwindow.adapter.ConfideHomeGoodAdapter
import com.ydl.ydlcommon.view.SpaceItemDecorator
import com.yidianling.common.tools.RxImageTool
import kotlinx.android.synthetic.main.confide_good_popup_window.view.*



/**
 * @author yuanwai
 * @描述:倾诉首页--擅长方向popWindow
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/22
 */
class ConfideHomeGoodPopupWindow(context: Context, goodsList: ArrayList<ConfideHomeFiterItemBean>, selectedGoodsList: ArrayList<ConfideHomeFiterItemBean>)
    : PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT) {
    var onGoodSelectedListener: OnGoodSelectedListener? = null
    //擅长方向列表数据
    private var goodsList: ArrayList<ConfideHomeFiterItemBean>? = null
    //已选择的擅长方向数据
    private var selectedGoodsList: ArrayList<ConfideHomeFiterItemBean>? = null

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.confide_good_popup_window, null)
        this.contentView = view
        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        val rvGood = view.rvGood
        val tvTitle = view.tv_title
        tvTitle.text = "擅长方向"
        if (null == this.goodsList){
            this.goodsList = ArrayList()
        }else{
            (this.goodsList as ArrayList).clear()
        }
        this.goodsList!!.addAll(goodsList)
        if (null == this.selectedGoodsList){
            this.selectedGoodsList = ArrayList()
        }else{
            (this.selectedGoodsList as ArrayList).clear()
        }
        this.selectedGoodsList!!.addAll(selectedGoodsList)
        var goodAdapter: ConfideHomeGoodAdapter? = null
        if (null == rvGood.adapter){
            goodAdapter = ConfideHomeGoodAdapter(context, this.goodsList!!, this.selectedGoodsList!!)
            rvGood.adapter = goodAdapter
            rvGood.layoutManager =
                GridLayoutManager(
                    context,
                    3,
                    LinearLayoutManager.VERTICAL,
                    false
                )
            rvGood.addItemDecoration(SpaceItemDecorator(RxImageTool.dp2px(8f), 3))
        }
        inputMethodMode = PopupWindow.INPUT_METHOD_NEEDED
        view.btnConfirm.setOnClickListener {
            onGoodSelectedListener?.onGoodSelected(this.selectedGoodsList!!)
            dismiss()
        }
        view.btnReset.setOnClickListener {
            goodAdapter?.cleanSelectedGoods()
        }
        view.v_zhezhao.setOnClickListener {
            dismiss()
        }
    }

    interface OnGoodSelectedListener {
        fun onGoodSelected(selectedGoodsList: ArrayList<ConfideHomeFiterItemBean>)
    }
}