package com.ydl.confide.home.popwindow

import android.content.Context
import android.graphics.drawable.BitmapDrawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.PopupWindow
import android.widget.TextView
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeAllFiltersBean
import com.ydl.confide.home.bean.ConfideHomeFiterItemBean
import com.ydl.confide.home.popwindow.adapter.ConfideHomeGoodAdapter
import com.ydl.ydlcommon.view.SpaceItemDecorator
import com.yidianling.common.tools.RxImageTool
import kotlinx.android.synthetic.main.confide_sexage_popup_window.view.*

/**
 * @author yuanwai
 * @描述:倾诉首页--性别年龄popWindow
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/22
 */
class ConfideHomeSexAgePopupWindow(context: Context, sexData: ArrayList<ConfideHomeFiterItemBean>,ageData : ArrayList<ConfideHomeFiterItemBean>, allFiltersBean: ConfideHomeAllFiltersBean)
    : PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT) {
    var onGoodSelectedListener: OnSexAgeSelectedListener? = null
    //性别数据集
    private var sexData: ArrayList<ConfideHomeFiterItemBean>? = null
    //年龄数据集
    private var ageData: ArrayList<ConfideHomeFiterItemBean>? = null
    //已选择的性别数据
    private var selectSex : ConfideHomeFiterItemBean? = null
    //已选择的年龄数据集
    private var selectedAge: ArrayList<ConfideHomeFiterItemBean>? = null

    private var sexAgeAdapter : ConfideHomeGoodAdapter? = null

    private var mAllFiltersBean : ConfideHomeAllFiltersBean? = null

    init {
        val view = LayoutInflater.from(context).inflate(R.layout.confide_sexage_popup_window, null)
        this.contentView = view
        this.isFocusable = true
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        val rvAge = view.rvAge
        val tvSexTitle = view.tv_sexTitle
        val tvAgeTitle = view.tv_ageTitle
        tvSexTitle.text = "性别筛选"
        tvAgeTitle.text = "年龄筛选"
        if (null == mAllFiltersBean){
            mAllFiltersBean = ConfideHomeAllFiltersBean(allFiltersBean.page,"",allFiltersBean.selectSort,allFiltersBean.selectSex,allFiltersBean.selectAgeData,allFiltersBean.selectGoodData)
        }
        initData(sexData,ageData,mAllFiltersBean!!)
        initSexData(view,mAllFiltersBean!!)
        initAdapter(context,rvAge)
        inputMethodMode = PopupWindow.INPUT_METHOD_NEEDED
        view.btnConfirm.setOnClickListener {
            onGoodSelectedListener?.onSexAgeSelected(this.selectSex!!,this.selectedAge!!)
            dismiss()
        }
        view.btnReset.setOnClickListener {
            selectSex = ConfideHomeFiterItemBean().apply {
                id = "-1"
                name = ""
            }
            mAllFiltersBean!!.selectSex = selectSex
            initSexData(view,mAllFiltersBean!!)
            sexAgeAdapter?.cleanSelectedGoods()
        }
        view.v_zhezhao.setOnClickListener {
            dismiss()
        }
    }

    /**
     * 初始化数据
     */
    private fun initData(sexData: ArrayList<ConfideHomeFiterItemBean>,ageData : ArrayList<ConfideHomeFiterItemBean>,allFiltersBean: ConfideHomeAllFiltersBean){
        //初始化已选择性别数据
        if (null == selectSex){
            selectSex = ConfideHomeFiterItemBean().apply { id="-1"
                name=""}
        }
        if (null != allFiltersBean.selectSex){
            selectSex!!.id = allFiltersBean.selectSex!!.id
            selectSex!!.name = allFiltersBean.selectSex!!.name
        }
        //初始化性别数据集
        if (null == this.sexData){
            this.sexData = ArrayList()
        }else{
            (this.sexData as ArrayList).clear()
        }
        this.sexData!!.addAll(sexData)
        //初始化年龄数据集
        if (null == this.ageData){
            this.ageData = ArrayList()
        }else{
            (this.ageData as ArrayList).clear()
        }
        this.ageData!!.addAll(ageData)
        //初始化已选择年龄数据集
        if (null == this.selectedAge){
            this.selectedAge = ArrayList()
        }else{
            (this.selectedAge as ArrayList).clear()
        }
        this.selectedAge!!.addAll(allFiltersBean.selectAgeData!!)
    }
    /**
     * 初始化性别数据
     */
    private fun initSexData(view : View,allFiltersBean: ConfideHomeAllFiltersBean){
        var tvSex1 = view.findViewById<TextView>(R.id.tvSex1)
        var tvSex2 = view.findViewById<TextView>(R.id.tvSex2)
        if (null != sexData && sexData!!.size > 0){
            tvSex1.text = sexData!![0].name
            tvSex1.setOnClickListener {
                if (selectSex!!.id == sexData!![0].id){
                    selectSex!!.id = "-1"
                    selectSex!!.name = ""
                    setSelect(tvSex1,false)
                }else{
                    selectSex!!.id = sexData!![0].id
                    selectSex!!.name = sexData!![0].name
                    setSelect(tvSex1,true)
                    setSelect(tvSex2,false)
                }
            }
        }
        if (null != sexData && sexData!!.size > 1) {
            tvSex2.text = sexData!![1].name
            tvSex2.setOnClickListener {
                if (selectSex!!.id == sexData!![1].id){
                    selectSex!!.id = "-1"
                    selectSex!!.name = ""
                    setSelect(tvSex2,false)
                }else{
                    selectSex!!.id = sexData!![1].id
                    selectSex!!.name = sexData!![1].name
                    setSelect(tvSex1,false)
                    setSelect(tvSex2,true)
                }
            }
        }
        if (null == sexData || null == allFiltersBean.selectSex){
            return
        }
        if (sexData!!.size > 0 && allFiltersBean.selectSex!!.id == sexData!![0].id){
            setSelect(tvSex1,true)
        }else if (sexData!!.size > 1 && allFiltersBean.selectSex!!.id == sexData!![1].id){
            setSelect(tvSex2,true)
        }else{
            setSelect(tvSex1,false)
            setSelect(tvSex2,false)
        }
    }

    /**
     * 设置性别选中样式
     */
    private fun setSelect(tvSex1: TextView,boolean: Boolean){
        if (boolean){
            tvSex1.setBackgroundResource(R.drawable.confide_filter_select_sel)
            tvSex1.setTextColor(tvSex1.context.resources.getColor(R.color.platform_main_theme))
        }else{
            tvSex1.setBackgroundResource(R.drawable.confide_filter_select_nor)
            tvSex1.setTextColor(tvSex1.context.resources.getColor(R.color._6))
        }
    }

    private fun initAdapter(context: Context,rvAge : RecyclerView){
        //初始化年龄适配器
        if (null == rvAge.adapter){
            sexAgeAdapter = ConfideHomeGoodAdapter(context, this.ageData!!, this.selectedAge!!)
            rvAge.adapter = sexAgeAdapter
            rvAge.layoutManager = GridLayoutManager(
                context,
                3,
                LinearLayoutManager.VERTICAL,
                false
            )
            rvAge.addItemDecoration(SpaceItemDecorator(RxImageTool.dp2px(8f), 3))
        }
    }

    interface OnSexAgeSelectedListener {
        fun onSexAgeSelected(sexData : ConfideHomeFiterItemBean,ageData: ArrayList<ConfideHomeFiterItemBean>)
    }
}