package com.ydl.confide.home.presenter

import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.confide.home.http.ConfideRecommendParam
import com.ydl.confide.home.model.ConfideHomeModelImpl
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.ydl.ydlcommon.mvp.base.BasePresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.common.tools.RxNetTool
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer

/**
 * @author yuanwai
 * @描述:倾诉首页逻辑实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10
 */
class ConfideHomePresenterImpl : BasePresenter<IConfideHomeContract.View, IConfideHomeContract.Model>(),
    IConfideHomeContract.Presenter {

    override fun createModel(): IConfideHomeContract.Model {
        return ConfideHomeModelImpl()
    }

    /**
     * 请求首页数据
     */
    override fun confideHomeRequest(isRefresh: Boolean) {
        if (!RxNetTool.isConnected(mView.getContext())) {
            mView.confideHomeRequestFail()
            return
        }
        val disposable = mModel.confideHomeRequest()
            .map { it }
            .filter { it != null }
            .compose(RxUtils.applySchedulers(mView as IView))
            .doFinally { mView.hideLoading() }
            .subscribe(Consumer {
                mView.confideHomeResponse(it)
            }, object : ThrowableConsumer() {
                override fun accept(msg: String) {
                    mView.confideHomeRequestFail()
                }
            })
    }

    /**
     * 为你推荐列表(筛选调用)
     */
    override fun recommendList(param: ConfideRecommendParam) {
        if (!RxNetTool.isConnected(mView.getContext())) {
            mView.showError1("网络不给力")
            return
        }
        val disposable = mModel.recommendList(param)
            .map { it }
            .filter { it != null }
            .compose(RxUtils.applySchedulers(mView as IView))
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(Consumer {
                mView.recommendListResponse(it)
            }, object : ThrowableConsumer() {
                override fun accept(msg: String) {
                    mView.showError1(msg)
                }
            })
    }

    /**
     * 为你推荐列表（翻页时调用）
     */
    override fun recommendListMore(param: ConfideRecommendParam) {
        if (!RxNetTool.isConnected(mView.getContext())) {
            mView.showError1("网络不给力")
            return
        }
        val disposable = mModel.recommendList(param)
            .map { it }
            .filter { it != null }
            .compose(RxUtils.applySchedulers(mView as IView))
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(Consumer {
                mView.recommendListMoreResponse(it)
            }, object : ThrowableConsumer() {
                override fun accept(msg: String) {
                    mView.showError(msg)
                    mView.showError1(msg)
                }
            })
    }
}