package com.ydl.confide.home.section

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.widget.ConfideHomeCategoryView
import com.ydl.ydlcommon.adapter.section.Section

/**
 * @author yuanwai
 * @描述:倾诉首页 分类 适配器
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10 0010
 */
class ConfideHomeCategorySection(var context: Context, var confideHomeEvent : IConfideHomeEvent,var homeView : IConfideHomeContract.View) : Section<RecyclerView.ViewHolder>(0) {
    override fun getSectionId(): Int {
        return IConfideHomeConfig.SECTION_CATEGORY
    }

    private var data : ConfideHomeDataBean? = null

    override fun getTotalDataNum(): Int {
        return 1
    }

    override fun getItemViewType(position: Int): Int {
        return IConfideHomeConfig.SECTION_CATEGORY
    }

    fun setData(data : ConfideHomeDataBean){
        this.data = data
    }

    override fun onCreateViewHolder(parent: ViewGroup?, viewType: Int): RecyclerView.ViewHolder {
        return when(viewType){
        //banner
            IConfideHomeConfig.SECTION_CATEGORY -> {
                CategoryViewHolder(ConfideHomeCategoryView(context,confideHomeEvent,homeView))
            }
            else -> {
                EmptyViewHolder(View.inflate(context,R.layout.confide_view_empty,null))
            }
        }
    }

    override fun bindViewHolder(holder: RecyclerView.ViewHolder?, position: Int) {
        if (holder is CategoryViewHolder){
            holder.categoryView!!.initData(this.data!!)
        }
    }

    override fun isBelongTo(viewType: Int): Boolean {
        return viewType.toString().startsWith(IConfideHomeConfig.SECTION_CATEGORY.toString())
    }

    override fun isHeadType(position: Int): Boolean {
        return false
    }

    override fun isFooterType(position: Int): Boolean {
        return false
    }


    /**
     * 分类测评 viewHolder
     */
    inner class CategoryViewHolder(itemView: ConfideHomeCategoryView) : RecyclerView.ViewHolder(itemView) {
        var categoryView: ConfideHomeCategoryView? = null

        init {
            categoryView = itemView
        }
    }

    /**
     * 空View
     */
    inner class EmptyViewHolder(itemViews: View) :  RecyclerView.ViewHolder(itemViews) {
        private var itemViews: View? = null

        init {
            this.itemViews = itemViews
        }
    }
}