package com.ydl.confide.home.section

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import com.yidianling.common.tools.RxImageTool
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.widget.ConfideHomeFilterView
import com.ydl.ydlcommon.adapter.section.Section

/**
 * @author yuanwai
 * @描述:为你推荐筛选模块section
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/21 0010
 */
class ConfideHomeFilterSection(var context: Context,var view : IConfideHomeContract.View) : Section<RecyclerView.ViewHolder>(0) {

    private val FOOTER = 200

    private var mFilterViewHolder : FilterViewHolder? = null

    override fun getSectionId(): Int {
        return IConfideHomeConfig.SECTION_RECOMMEND_FILTER
    }

    private var data: ConfideHomeDataBean? = null

    override fun getItemViewType(position: Int): Int {
        if (isFooterType(position)) {
            return combineType(IConfideHomeConfig.SECTION_RECOMMEND_FILTER, this.FOOTER)
        } else {
            return IConfideHomeConfig.SECTION_RECOMMEND_FILTER
        }
    }

    fun setData(data: ConfideHomeDataBean) {
        this.data = data
    }

    override fun bindViewHolder(holder: RecyclerView.ViewHolder?, position: Int) {
        if (holder is FilterViewHolder) {
            holder.filterView.initData(data!!)
        }else if (holder is FooterViewHolder){

        }
    }

    override fun getTotalDataNum(): Int {
        return 2
    }

    fun getFilterViewHolder() : FilterViewHolder? {
        return mFilterViewHolder
    }

    override fun onCreateViewHolder(parent: ViewGroup?, viewType: Int): RecyclerView.ViewHolder {
        if (viewType == combineType(IConfideHomeConfig.SECTION_RECOMMEND_FILTER, FOOTER)) {
            var param = RecyclerView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,RxImageTool.dip2px(0.5f))
            var dp15 = RxImageTool.dip2px(15f)
            param.setMargins(dp15,0,dp15,0)
            var footerView = View(context)
            footerView.setBackgroundColor(context.resources.getColor(R.color.confide_filters_line))
            footerView.layoutParams = param
            return FooterViewHolder(footerView)
        }else{
            mFilterViewHolder = FilterViewHolder(ConfideHomeFilterView(context,view))
            return mFilterViewHolder as FilterViewHolder
        }
    }

    override fun isBelongTo(viewType: Int): Boolean {
        return viewType.toString().startsWith(IConfideHomeConfig.SECTION_RECOMMEND_FILTER.toString())
    }


    override fun isHeadType(position: Int): Boolean {
        return false
    }

    override fun isFooterType(position: Int): Boolean {
        if (position == 1){
            return true
        }
        return false
    }
    
    inner class FilterViewHolder(var filterView: ConfideHomeFilterView) : RecyclerView.ViewHolder(filterView)

    inner class FooterViewHolder(var footerView : View) : RecyclerView.ViewHolder(footerView)
}