package com.ydl.confide.home.section

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.ViewGroup
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.widget.ConfideHomeHeadView
import com.ydl.confide.home.widget.ConfideHomeListenAndFoundView
import com.ydl.ydlcommon.adapter.section.Section

/**
 * @author Jim
 * @描述:听声寻人section
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/11 0011
 */
class ConfideHomeListenAndFoundSection(var context: Context, var view: IConfideHomeContract.View, var confideHomeEvent: IConfideHomeEvent) : Section<RecyclerView.ViewHolder>(0) {

    override fun getSectionId(): Int {
        return IConfideHomeConfig.SECTION_RECENTLY_CONFIDED
    }

    private var data: ConfideHomeDataBean? = null
    private val HEADER = 200
    private var confideHomeListenAndFoundView: ConfideHomeListenAndFoundView? = null

    fun setData(data: ConfideHomeDataBean) {
        this.data = data
    }

    override fun bindViewHolder(holder: RecyclerView.ViewHolder?, position: Int) {
        if (holder is HeadViewHolder) {
            holder.confideHeadView.initData(this.data!!)
        } else if (holder is ConfideHomeListenAndFoundViewHolder) {
            holder.confideHomeListenAndFoundView.initData(this.data!!)
        }
    }

    override fun getTotalDataNum(): Int {
        var count = 1
        if (data?.head != null) {
            count++
        } else if (data?.footer != null) {
            count++
        }
        return count
    }

    override fun getItemViewType(position: Int): Int {
        if (isHeadType(position)) {
            return combineType(IConfideHomeConfig.SECTION_SOUND, this.HEADER)
        } else {
            return IConfideHomeConfig.SECTION_SOUND
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup?, viewType: Int): RecyclerView.ViewHolder {
        if (viewType == combineType(IConfideHomeConfig.SECTION_SOUND, HEADER)) {
            return HeadViewHolder(ConfideHomeHeadView(context, confideHomeEvent))
        } else {
            confideHomeListenAndFoundView = ConfideHomeListenAndFoundView(context, confideHomeEvent)
            return ConfideHomeListenAndFoundViewHolder(confideHomeListenAndFoundView!!)
        }
    }

    override fun isBelongTo(viewType: Int): Boolean {
        return viewType.toString().startsWith(IConfideHomeConfig.SECTION_SOUND.toString())
    }

    override fun isHeadType(position: Int): Boolean {
        if (data?.head == null) {
            return false
        } else if (position == 0) {
            return true
        }
        return false
    }

    override fun isFooterType(position: Int): Boolean {
        return false
    }

    inner class HeadViewHolder(var confideHeadView: ConfideHomeHeadView) : RecyclerView.ViewHolder(confideHeadView)


    inner class ConfideHomeListenAndFoundViewHolder(var confideHomeListenAndFoundView: ConfideHomeListenAndFoundView) : RecyclerView.ViewHolder(confideHomeListenAndFoundView)
}