package com.ydl.confide.home.util

import android.widget.TextView
import androidx.databinding.BindingAdapter
import com.ydl.confide.R

@BindingAdapter("confideLineText")
fun TextView.confideLineText(line: Int) {
    when (line) {
        1 -> {
            text = "立即拨打"
        }
        2 -> {
            text = "已离线"
        }
        3 -> {
            text = "通话中"
        }
        4 -> {
            text = "继续倾诉"
        }
        5 -> {
            text = "已离线，可预约"
        }
        6 -> {
            text = "已离线，可留言"
        }
    }
}


@BindingAdapter("confideLineRecentText")
fun TextView.confideLineRecentText(line: Int) {
    when (line) {
        1 -> {
            text = "空闲"
            setBackgroundResource(R.drawable.confide_bg_main_color)
        }
        2 -> {
            text = "离线"
            setBackgroundResource(R.drawable.confide_bg_color_666666)
        }
        3 -> {
            text = "通话中"
            setBackgroundResource(R.drawable.confide_bg_color_ff8f38)
        }
        else ->{
            text = ""
            background = null
        }
    }
}