package com.ydl.confide.home.widget

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import com.yidianling.common.tools.RxImageTool
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeBodyBean
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.ydlcommon.view.banner.GlideImageLoader
import kotlinx.android.synthetic.main.confide_banner_view.view.*

/**
 * @author yuanwai
 * @描述:倾诉首页banner
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/10
 */
class ConfideHomeBannerView(context: Context,
                            //
                            private var confideHomeEvent: IConfideHomeEvent) : FrameLayout(context) {
    /**
     * banner数据缓存
     */
    private var mDataList: List<ConfideHomeBodyBean>? = null
    /**
     * 数据缓存
     */
    private var mDataBean: ConfideHomeDataBean? = null

    private var margin = 0

    init {
        initView()
    }

    private fun initView() {
        val params = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        View.inflate(context, R.layout.confide_banner_view, this)
        layoutParams = params
        margin = RxImageTool.dip2px(2.5f)
    }

    fun initData(dataBean: ConfideHomeDataBean?) {
        if (null == dataBean ||
                dataBean.body == null ||
                dataBean.body!!.isEmpty()) {
            visibility = View.GONE
            return
        }
        mDataBean = dataBean

        visibility = View.VISIBLE

        if (null == mDataList) {
            mDataList = ArrayList()
        } else {
            (mDataList as ArrayList).clear()
        }
        (mDataList as ArrayList<ConfideHomeBodyBean>).addAll(mDataBean!!.body!!)

        var urlLists = ArrayList<String>()
        var count = (mDataList as ArrayList<ConfideHomeBodyBean>).size - 1
        for (index in 0..count) {
            urlLists.add((mDataList as ArrayList<ConfideHomeBodyBean>)[index].bannerImageUrl!!)
        }
        banner.setImageLoader(GlideImageLoader(R.color.confide_new_divide_color,6)).setImages(urlLists).start()

        banner.setOnBannerListener {
            confideHomeEvent!!.bannerClick((mDataList as ArrayList<ConfideHomeBodyBean>)[it].bannerLinkUrl, it, (mDataList as ArrayList<ConfideHomeBodyBean>)[it].bannerTitle)
        }
    }
}