package com.ydl.confide.home.widget

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.common.tools.RxImageTool
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeBodyBean
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.confide.home.event.IConfideHomeEvent
import kotlinx.android.synthetic.main.confide_category_view.view.*

/**
 * @author yuanwai
 * @描述:倾诉首页--分类View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/21
 */
class ConfideHomeCategoryView(mContext: Context,
                              //倾诉首页事件类
                              private var confideHomeEvent: IConfideHomeEvent,
                              //倾诉首页View接口
                              private var homeView : IConfideHomeContract.View) : LinearLayout(mContext) {
    init {
        initView()
    }

    private fun initView(){
        var params = ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,RxImageTool.dip2px(106f))
        View.inflate(context, R.layout.confide_category_view,this)
        layoutParams = params
        orientation = HORIZONTAL
        setBackgroundResource(R.color.confide_category_bg)
    }

    fun initData(bean: ConfideHomeDataBean?){
        if (null == bean || null == bean.body || bean.body.isEmpty()){
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        initItem1Data(bean.body[0])
        if (bean.body.size > 1){
            initItem2Data(bean.body[1])
        }
    }

    private fun initItem1Data(bodyBean: ConfideHomeBodyBean?){
        v_item1.initData(bodyBean,confideHomeEvent,homeView)
    }

    private fun initItem2Data(bodyBean: ConfideHomeBodyBean?){
        v_item2.initData(bodyBean,confideHomeEvent,homeView)
    }
}