package com.ydl.confide.home.widget

import android.content.Context
import androidx.annotation.Nullable
import androidx.core.content.ContextCompat
import android.util.AttributeSet
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeBodyBean
import com.ydl.confide.home.bean.ConfideHomeDataBean
import com.ydl.confide.home.contract.IConfideHomeContract
import com.ydl.ydlcommon.utils.ScreenUtil
import com.ydl.ydlcommon.view.DrawableRightTextView
import com.yidianling.common.tools.RxImageTool

/**
 * @author yuanwai
 * @描述:倾诉首页--为你推荐筛选View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/21
 */
class ConfideHomeFilterView(mContext: Context, @Nullable attrs: AttributeSet?, defStyleAttr: Int) : LinearLayout(mContext,attrs,defStyleAttr){

    constructor(mContext : Context,attrs : AttributeSet):this(mContext,attrs,0)

    constructor(mContext : Context,confideHomeView : IConfideHomeContract.View): this(mContext,null,0){
        this.confideHomeView = confideHomeView
    }

    private var first = false
    private var confideHomeView : IConfideHomeContract.View? = null

    init {
        initView()
    }

    private fun initView() {
        var params = ViewGroup.LayoutParams(ScreenUtil.screenWidth,RxImageTool.dip2px(48f))
        layoutParams = params
        orientation = HORIZONTAL
    }

    fun setHomeView(confideHomeView : IConfideHomeContract.View){
        this.confideHomeView = confideHomeView
    }

    fun initData(dataBean: ConfideHomeDataBean?){
        if (null == dataBean || null == dataBean.body || dataBean.body.isEmpty()){
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        for (index in dataBean.body.indices){
            if (childCount == 0){
                createView()
            }else if (index > childCount - 1){
                createView()
            }
            if (index < childCount){
                bindData(getChildAt(index),dataBean.body[index])
            }
        }
        first = true
    }

    private fun createView(){
        var params = LinearLayout.LayoutParams(0,RxImageTool.dip2px(48f))
        params.weight = 1f
        var textView = DrawableRightTextView(context)
        textView.id = R.id.tv_title
        textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 13f)
        textView.gravity = Gravity.CENTER
        textView.setTextColor(ContextCompat.getColor(context, R.color._6))
        setDrawableRight(textView)
        textView.layoutParams = params
        addView(textView)
    }

    private fun setDrawableRight(textView: DrawableRightTextView){
        var drawable  = context.resources.getDrawable(R.drawable.platform_ic_arrow_drop_down_grey_500_18dp)
        // 这一步必须要做,否则不会显示.
        drawable.setBounds(0, 0, drawable.minimumWidth, drawable.minimumHeight)
        textView.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable, null)
    }

    private fun bindData(view : View,bodyBean: ConfideHomeBodyBean){
        var textView = view.findViewById<DrawableRightTextView>(R.id.tv_title)
        textView.text = bodyBean.filterName
        textView.setTag(R.id.tv_title,bodyBean)
        if ("排序" == bodyBean.filterName){
            textView.setTextColor(ContextCompat.getColor(context, R.color.platform_main_theme))
//            textView.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.ic_arrow_drop_down_green_18dp, 0)
        }
        textView.setOnClickListener {
            showPopWindow(textView,textView.getTag(R.id.tv_title) as ConfideHomeBodyBean)
        }
    }

    private fun showPopWindow(textView : DrawableRightTextView,bodyBean: ConfideHomeBodyBean){
        if (null == confideHomeView){
            return
        }
        when(bodyBean.filterType){
            1 -> {
                //综合排序
                confideHomeView!!.showSortPopupWindow(textView,textView,bodyBean)
            }
            2 -> {
                //性别年龄
                confideHomeView!!.showSexAgePopupWindow(textView,textView,bodyBean)
            }
            3 -> {
                //擅长方向
                confideHomeView!!.showGoodPopupWindow(textView,textView,bodyBean)
            }
        }
    }

    fun refreshView(){
        var count = childCount
        for (index in 0..count){
            var view = getChildAt(index)
            if (view is DrawableRightTextView){
                if ("排序" == view.text){
                    view.setTextColor(ContextCompat.getColor(context, R.color.platform_main_theme))
                }else{
                    view.setTextColor(ContextCompat.getColor(context, R.color._6))
                }
            }
        }
    }

    /**
     * 根据类型获取View
     */
    fun getTextViewByType(type : Int) : DrawableRightTextView? {
        var count = childCount
        for (index in 0..count){
            var view = getChildAt(index) as DrawableRightTextView
            var bodyBean = view.getTag(R.id.tv_title) as ConfideHomeBodyBean
            if (bodyBean.filterType == type){
                return view
            }
        }
        return null
    }
}