package com.ydl.confide.home.widget

import android.content.Context
import android.text.TextUtils
import android.view.View
import android.widget.FrameLayout
import com.ydl.confide.R
import com.ydl.confide.home.bean.ConfideHomeBodyBean
import com.ydl.confide.home.config.IConfideHomeConfig
import com.ydl.confide.home.event.IConfideHomeEvent
import com.ydl.confide.home.util.ConfideHomeUtils
import kotlinx.android.synthetic.main.confide_listen_and_found_item_view.view.*

/**
 * @author yuanwai
 * @描述:倾诉首页--听声寻人Item View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/22
 */
class ConfideHomeListenAndFoundItemView(mContext: Context, private var confideHomeEvent: IConfideHomeEvent) : FrameLayout(mContext) {
    init {
        initView()
    }

    private fun initView() {
        View.inflate(context, R.layout.confide_listen_and_found_item_view, this)
    }

    /**
     * 数据初始化
     */
    fun initData(bodyBean: ConfideHomeBodyBean?, position: Int) {
        if (null == bodyBean) {
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        //设置在线状态
        setLineStatu(bodyBean)
        //设置是否播放动画
        setPlay(bodyBean, position)
        //设置名称
        tv_name.text = bodyBean.confidedName
        //设置性别
        setSex(bodyBean)
        //设置向TA倾诉文案
        setConfideNum(bodyBean)
        //设置接通率文案
        setConnection(bodyBean)
        //设置咨询师简介
        tv_content.text = bodyBean.confideContent
        //设置向TA倾诉按钮状态
        setConfideButton(bodyBean)
        //界面跳转事件
        this.setOnClickListener {
            click(bodyBean)
        }
    }

    /**
     * 设置在线状态
     */
    private fun setLineStatu(bodyBean: ConfideHomeBodyBean) {
        tv_isLine.visibility = View.VISIBLE
        when (bodyBean.confideLine) {//1在线 2离线 3通话中
            1 -> {
                tv_isLine.text = "在线"
                tv_isLine.setBackgroundResource(R.drawable.confide_bg_main_color)
            }
            2 -> {
                tv_isLine.text = "离线"
                tv_isLine.setBackgroundResource(R.drawable.confide_bg_color_666666)
            }
            3 -> {
                tv_isLine.text = "通话中"
                tv_isLine.setBackgroundResource(R.drawable.confide_bg_color_ff8f38)
            }

            else -> {
                tv_isLine.visibility = View.GONE
            }
        }
    }

    /**
     * 设置是否播放动画
     */
    private fun setPlay(bodyBean: ConfideHomeBodyBean, position: Int) {
        if (bodyBean.confideIsPlay) {
            //启动动画
            ConfideHomeUtils.startPlayAnim(context, img_disc)
        } else {
            //暂停动画
            ConfideHomeUtils.stopPlayAnim(img_disc)
        }
        if (TextUtils.isEmpty(bodyBean.confideVoice)) {
            return
        }
        img_mask.setOnClickListener {
            if (bodyBean.confideIsPlay!!) {
                confideHomeEvent.pauseVoice()
            } else {
                confideHomeEvent.playVoice(IConfideHomeConfig.TYPE_SOUND, position, bodyBean.confideVoice)
            }
        }
    }

    /**
     * 设置性别
     */
    private fun setSex(bodyBean: ConfideHomeBodyBean) {
        if (bodyBean.confideSex == 1) {
            img_sex.setImageResource(R.drawable.confide_new_male)
        } else {
            img_sex.setImageResource(R.drawable.confide_new_female)
        }
    }

    /**
     * 设置向TA倾诉文案
     */
    private fun setConfideNum(bodyBean: ConfideHomeBodyBean) {
        if (TextUtils.isEmpty(bodyBean.confideNum)) {
            tv_confideNum.visibility = View.GONE
            tv_tv_confideNumContent.visibility = View.GONE
        } else {
            tv_confideNum.visibility = View.VISIBLE
            tv_tv_confideNumContent.visibility = View.VISIBLE
            tv_confideNum.text = bodyBean.confideNum
        }
    }

    /**
     * 设置接通率文案
     */
    private fun setConnection(bodyBean: ConfideHomeBodyBean) {
        if (TextUtils.isEmpty(bodyBean.confideConnection)) {
            tv_Connection.visibility = View.INVISIBLE
            tv_ConnectionContent.visibility = View.INVISIBLE
        } else {
            tv_Connection.visibility = View.VISIBLE
            tv_ConnectionContent.visibility = View.VISIBLE
            tv_Connection.text = bodyBean.confideConnection
        }
    }

    /**
     * 设置向TA倾诉按钮状态
     */
    private fun setConfideButton(bodyBean: ConfideHomeBodyBean) {
        when (bodyBean.confideLine) {//1.在线 2.离线 3.通话中 4.继续倾诉
            1 -> {
                tv_confide.setBackgroundResource(R.drawable.confide_line_1)
            }
            2 -> {
                tv_confide.setBackgroundResource(R.drawable.confide_line_2)
            }
            3 -> {
                tv_confide.setBackgroundResource(R.drawable.confide_line_3)
            }
            4 ->{
                tv_confide.setBackgroundResource(R.drawable.confide_line_4)
            }
        }
    }

    /**
     * 点击事件
     */
    private fun click(bodyBean: ConfideHomeBodyBean) {
        when (bodyBean.confideLine) {//1在线 2离线 3通话中
            1, 3,4 -> {

                confideHomeEvent.soundClick(bodyBean.linkUrl)
            }
            2 -> {
                //跳转私聊 并发送自定义消息
                confideHomeEvent.toChatForMsg(""+bodyBean.uid)
            }
        }
    }
}