package com.ydl.confide.home.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.yidianling.common.tools.RxImageTool;
import com.ydl.confide.R;

public class ConfidePlayerFloatView extends FrameLayout {
    private float mTouchStartX;
    private float mTouchStartY;
    private float x;
    private float y;

    private ImageView playState;
    private ImageView playClose;
    private ImageView playHead;
    private View dividerLine;
    boolean mBoolean;

    private int mTouchSlop;

    private boolean isFmPlay;

    private boolean isClick;
    private boolean isMove;

    private WindowManager wm;
    private int dp3 = 0;

    //此wmParams为获取的全局变量，用以保存悬浮窗口的属性
    public WindowManager.LayoutParams wmParams = new WindowManager.LayoutParams();

    public ConfidePlayerFloatView(Context context) {
        super(context);
        init(context);
    }

    @SuppressLint("ClickableViewAccessibility")
    private void init(Context context) {
        wm = (WindowManager) getContext().getSystemService(Context.WINDOW_SERVICE);
        dp3= RxImageTool.dip2px(3f);
        mTouchSlop = ViewConfiguration.get(getContext()).getScaledTouchSlop() + 5;
        View view = inflate(context, R.layout.confide_playing_float_btn, this);
        playHead = view.findViewById(R.id.play_head);
        playState = view.findViewById(R.id.play_state);
        playClose = findViewById(R.id.play_close);
        dividerLine = findViewById(R.id.hz_divider_line);
//        GlideApp.with(context)
//                .load(R.drawable.)
//                .circleCrop()
//                .into(playHead);

        playHead.setOnTouchListener((v, event) -> {
            x = event.getRawX();
            y = event.getRawY() - 25;
            Log.i("currP", "currX" + x + "====currY" + y);
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    //获取相对View的坐标，即以此View左上角为原点
                    mTouchStartX = event.getX();
                    mTouchStartY = event.getY();
                    break;
                case MotionEvent.ACTION_MOVE:
                    Log.i("TAG", "currX" + event.getX() + "====currY" + event.getY());
                    if (Math.abs(event.getX() - mTouchStartX) > mTouchSlop ||
                            Math.abs((event.getY() - mTouchStartY)) > mTouchSlop) {
                        Log.i("TAG", "is move");
                        updateViewPosition();
                        isMove = true;
                    }
                    break;
                case MotionEvent.ACTION_UP:
                    if (Math.abs(event.getX() - mTouchStartX) > mTouchSlop ||
                            Math.abs((event.getY() - mTouchStartY)) > mTouchSlop || isMove) {
                        Log.i("TAG", "is move");
                        updateViewPosition();
                    } else {
                        if (!isMove) {
//                            if (PhoneCallIn.INSTANCE.isFmPlaying()) {
//                                //FM播放页
//                                context.startActivity(PhoneCallIn.INSTANCE.fmDetailIntent((Activity) context, PhoneCallIn.INSTANCE.getFmId()));
//                            } else if (PhoneCallIn.INSTANCE.isCoursePlaying()) {
//                                //课程播放页
//                                PhoneCallIn.INSTANCE.startCoursePlayPage((Activity) context);
//
//                            }
                        }
                        Log.i("TAG", "is click");
                    }
                    isClick = false;
                    isMove = false;
                    mTouchStartX = mTouchStartY = 0;
                    break;
            }
            return true;
        });

        playClose.setOnTouchListener((v, event) -> {
            x = event.getRawX();
            y = event.getRawY() - 25;
            Log.i("currP", "currX" + x + "====currY" + y);
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    //获取相对View的坐标，即以此View左上角为原点
                    mTouchStartX = event.getX();
                    mTouchStartY = event.getY();
                    break;
                case MotionEvent.ACTION_MOVE:
                    Log.i("TAG", "currX" + event.getX() + "====currY" + event.getY());
                    if (Math.abs(event.getX() - mTouchStartX) > mTouchSlop ||
                            Math.abs((event.getY() - mTouchStartY)) > mTouchSlop) {
                        Log.i("TAG", "is move");
                        updateViewPosition();
                        isMove = true;
                    }
                    break;
                case MotionEvent.ACTION_UP:
                    if (Math.abs(event.getX() - mTouchStartX) > mTouchSlop ||
                            Math.abs((event.getY() - mTouchStartY)) > mTouchSlop || isMove) {
                        Log.i("TAG", "is move");
                        updateViewPosition();
                    } else {
                        if (!isMove) {
                            ConfidePlayerFloatView.this.setVisibility(GONE);
                        }
                        Log.i("TAG", "is click");
                    }
                    isClick = false;
                    isMove = false;
                    mTouchStartX = mTouchStartY = 0;
                    break;
            }
            return true;
        });

        playState.setOnTouchListener((v, event) -> {
            x = event.getRawX();
            y = event.getRawY() - 25;
            Log.i("currP", "currX" + x + "====currY" + y);
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    //获取相对View的坐标，即以此View左上角为原点
                    mTouchStartX = event.getX();
                    mTouchStartY = event.getY();
                    break;
                case MotionEvent.ACTION_MOVE:
                    Log.i("TAG", "currX" + event.getX() + "====currY" + event.getY());
                    if (Math.abs(event.getX() - mTouchStartX) > mTouchSlop ||
                            Math.abs((event.getY() - mTouchStartY)) > mTouchSlop) {
                        Log.i("TAG", "is move");
                        updateViewPosition();
                        isMove = true;
                    }
                    break;
                case MotionEvent.ACTION_UP:
                    if (Math.abs(event.getX() - mTouchStartX) > mTouchSlop ||
                            Math.abs((event.getY() - mTouchStartY)) > mTouchSlop || isMove) {
                        Log.i("TAG", "is move");
                        updateViewPosition();
                    } else {
                        if (!isMove) {
                            if (isFmPlay) {
                                playState.setImageResource(R.drawable.confide_play_stop);
                                playState.setPadding(dp3,dp3,dp3,dp3);
                                playClose.setVisibility(VISIBLE);
                                dividerLine.setVisibility(VISIBLE);
                                if (null != mPlayCallBack){
                                    mPlayCallBack.click(false);
                                }
                            }  else {
                                playState.setImageResource(R.drawable.confide_play_pause);
                                playState.setPadding(dp3,dp3,dp3,dp3);
                                playClose.setVisibility(GONE);
                                dividerLine.setVisibility(GONE);
                                if (null != mPlayCallBack){
                                    mPlayCallBack.click(true);
                                }
                            }
                        }
                        Log.i("TAG", "is click");
                    }
                    isClick = false;
                    isMove = false;
                    mTouchStartX = mTouchStartY = 0;
                    break;
            }
            return true;
        });
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        //获取相对屏幕的坐标，即以屏幕左上角为原点
        x = event.getRawX();
        y = event.getRawY() - 25;
        Log.i("currP", "currX" + x + "====currY" + y);
        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN:
                //获取相对View的坐标，即以此View左上角为原点
                mTouchStartX = event.getX();
                mTouchStartY = event.getY();
                break;
            case MotionEvent.ACTION_MOVE:
                updateViewPosition();
                break;
            case MotionEvent.ACTION_UP:
                updateViewPosition();
                mTouchStartX = mTouchStartY = 0;
                break;
        }
        return true;
    }

    private void updateViewPosition() {
        //更新浮动窗口位置参数
        wmParams.x = (int) (x - mTouchStartX);
        wmParams.y = (int) (y - mTouchStartY);
        wm.updateViewLayout(this, wmParams);
    }

    public void updatePlayState(Boolean isPlaying) {
        this.isFmPlay = isPlaying;
        if (isPlaying) {
            playState.setImageResource(R.drawable.confide_play_pause);
            playState.setPadding(dp3,dp3,dp3,dp3);
            playClose.setVisibility(GONE);
            dividerLine.setVisibility(VISIBLE);
        } else {
            playState.setImageResource(R.drawable.confide_play_stop);
            playState.setPadding(dp3,dp3,dp3,dp3);
            playClose.setVisibility(VISIBLE);
        }
    }
    private PlayCallBack mPlayCallBack;

    public void setPlayCallBack(PlayCallBack mPlayCallBack){
        this.mPlayCallBack = mPlayCallBack;
    }

    public interface PlayCallBack{
        //通知界面是暂停 还是播放 以此来刷新 updatePlayState方法的播放状态
        //MyPlayer类中的 isPlaying状态不好用 所以用这种方式更新
        void click(boolean isPlay);
    }
}