package com.ydl.confide.home.widget

import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Paint
import android.graphics.Rect
import android.view.View
import androidx.recyclerview.widget.RecyclerView
import com.yidianling.common.tools.RxImageTool

class FilterItemDecoration : RecyclerView.ItemDecoration() {

    private val bounds = Rect()
    private val paint = Paint().apply {
        color = Color.parseColor("#EFEFF1")
        strokeWidth = 2F
    }

    override fun getItemOffsets(outRect: Rect, view: View, parent: RecyclerView, state: RecyclerView.State) {
        if (view is ConfideHomeFilterView) {
            outRect.set(0, 0, 0, 1)
        }
    }


    override fun onDraw(c: Canvas, parent: RecyclerView, state: RecyclerView.State) {
        val count = parent.childCount
        for (i in 0 until count) {
            val child = parent.getChildAt(i)
            if (child is ConfideHomeFilterView) {
                parent.getDecoratedBoundsWithMargins(child, bounds)
                c.drawLine(
                    bounds.left.toFloat(),
                    bounds.top.toFloat(),
                    bounds.right.toFloat(),
                    bounds.top.toFloat(),
                    paint
                )
                c.drawLine(
                    bounds.left.toFloat(),
                    bounds.bottom.toFloat(),
                    bounds.right.toFloat(),
                    bounds.bottom.toFloat(),
                    paint
                )
            }
        }
    }
}