package com.ydl.confide.router

import android.app.Activity
import android.content.Context
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.im.api.service.IImService
import com.yidianling.user.api.service.IAppService
import com.yidianling.user.api.service.IUserService

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/25
 */
object PhoneCallIn {

    fun getImService(): IImService {
        return ModularServiceManager.provide(IImService::class.java)
    }

    fun getAppService(): IAppService {
        return ModularServiceManager.provide(IAppService::class.java)
    }

    fun getUserService(): IUserService {
        return ModularServiceManager.provide(IUserService::class.java)
    }

    fun isLogin(): Boolean {
        return getUserService()?.isLogin()?:false
    }


    fun loginWayIntent(activity: Activity): Intent? {
        return getUserService()?.loginWayIntent(activity)
    }

    /**
     * 私聊
     */
    fun startChat(context: AppCompatActivity, toUid: String, flag: Int, canTalk: Int) {
        getImService().startChat(context,toUid,flag,canTalk)
    }


    /**
     * 调用优先使用一键登录，并返回调用时的登录状态，
     * @param isOpenDialog true:一键登录使用弹窗展示 false:一键登录使用全屏模式
     * @return true：已登录，不触发登录跳转，false：未登录，优先一键登录
     * */
    fun loginByOneKeyLogin(context: Context, isOpenDialog: Boolean) :Boolean{
        return getUserService().loginByOneKeyLogin(context,isOpenDialog)
    }
}