package com.yidianling.consultant.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.recyclerview.widget.RecyclerView
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.consultant.R
import com.yidianling.consultant.model.bean.ConsultantTopBannerBean
import kotlinx.android.synthetic.main.consultant_top_banner_item.view.*

/**
 * Created by zqk on 17-9-20.
 */
class ConsultantTopAdapter(
    private val context: Context,
    private val consultList: MutableList<ConsultantTopBannerBean>
) : RecyclerView.Adapter<ConsultantTopAdapter.ViewHolder>() {
    override fun getItemCount(): Int = consultList.size

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val itemView =
            LayoutInflater.from(context).inflate(R.layout.consultant_top_banner_item, parent, false)
        return ViewHolder(itemView)
    }


    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val layoutParams = ViewGroup.LayoutParams(
            (context.getResources().getDisplayMetrics().widthPixels / 4.5).toInt(),
            ViewGroup.LayoutParams.WRAP_CONTENT
        )
        holder.itemView.layoutParams = layoutParams
        if (consultList[position].specialTopicSubhead?.isNotEmpty() == true) {
            holder.consult_tag.visibility = View.VISIBLE
            holder.consult_tag.text = consultList[position].specialTopicSubhead
            if (consultList[position].specialTopicSubhead?.toCharArray()?.size!! <= 2) {
                val params = FrameLayout.LayoutParams(
                    FrameLayout.LayoutParams.WRAP_CONTENT,
                    FrameLayout.LayoutParams.WRAP_CONTENT
                )
                params.setMargins(46, 0, 0, 0)
                holder.consult_tag.layoutParams = params
            }
        } else {
            holder.consult_tag.visibility = View.GONE
        }

        GlideApp.with(context)
            .load(consultList[position].topicImage)
            .into(holder.consult_img)
        holder.consult_title.text = consultList[position].specialTopicTitle
        holder.itemView.setOnClickListener {
            NewH5Activity.start(
                context,
                H5Params(consultList[position].specialTopicUrl.toString(), "")
            )
        }
    }


    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val consult_tag = itemView.consult_tag
        val consult_img = itemView.consult_img
        val consult_title = itemView.consult_title

    }
}