package com.yidianling.consultant.adapter

import android.annotation.SuppressLint
import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import com.yidianling.consultant.R
import com.yidianling.consultant.model.bean.EightCategoryBean
import kotlinx.android.synthetic.main.eight_category_list_item.view.*

/**
 * Created by zqk on 17-9-20.
 */
class EightCategoryAdapter(
    private val context: Context,
    private val eightCateList: MutableList<EightCategoryBean>,
    private val singleMultiple: Boolean
) : RecyclerView.Adapter<EightCategoryAdapter.ViewHolder>() {
    lateinit var onLeftClickListener: OnLeftClickListener
    override fun getItemCount(): Int = eightCateList.size

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val itemView =
            LayoutInflater.from(context).inflate(R.layout.eight_category_list_item, parent, false)
        return ViewHolder(itemView)
    }


    override fun onBindViewHolder(holder: ViewHolder, position: Int) {

        holder.eight_name.text = eightCateList[position].string
        holder.itemView.setOnClickListener {
            onLeftClickListener.onLeftClick(position)
        }

        if (eightCateList[position].selected) {
            holder.itemView.setBackgroundColor(ContextCompat.getColor(context, R.color.white))
            holder.eight_name.setTextColor(
                ContextCompat.getColor(
                    context,
                    R.color.platform_main_theme
                )
            )
            if (singleMultiple) {
                holder.single_selected_tag.visibility = View.VISIBLE
            } else {
                holder.single_selected_tag.visibility = View.INVISIBLE
            }
        } else {
            holder.eight_name.setTextColor(
                ContextCompat.getColor(
                    context,
                    R.color.platform_color_242424
                )
            )
            holder.single_selected_tag.visibility = View.INVISIBLE
            holder.itemView.setBackgroundColor(
                ContextCompat.getColor(
                    context,
                    R.color.platform_color_F7F7F7
                )
            )
        }
        if (eightCateList[position].hasData) {
            holder.multiple_choise.visibility = View.VISIBLE
        } else {
            holder.multiple_choise.visibility = View.INVISIBLE
        }
    }

    interface OnLeftClickListener {
        fun onLeftClick(leftPosition: Int)
    }

    fun setleftClick(leftListener: OnLeftClickListener) {
        this.onLeftClickListener = leftListener
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val eight_name = itemView.eight_name
        val multiple_choise = itemView.multiple_choise
        val single_selected_tag = itemView.single_selected_tag

    }
}