package com.yidianling.consultant.adapter

import android.content.Context
import android.graphics.Typeface
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.yidianling.consultant.R
import com.yidianling.consultant.listener.OnSortItemSelectedListener
import com.yidianling.consultant.model.bean.ReorderItem
import kotlinx.android.synthetic.main.consultant_item_sort.view.*

/**
 * Created by zqk on 17-9-20.
 */
class SortRecyclerViewAdapter(private val context: Context,
                              private val sortItems: ArrayList<ReorderItem>,
                              private val selectedSort: ReorderItem,
                              private val onItemSelectedListener: OnSortItemSelectedListener) : RecyclerView.Adapter<SortRecyclerViewAdapter.ViewHolder>() {

    override fun getItemCount(): Int = sortItems.size

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val itemView = LayoutInflater.from(context).inflate(R.layout.consultant_item_sort, parent, false)
        return ViewHolder(itemView)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val item = sortItems[position]
        holder.tvSort.text = item.value
        if (item.key == selectedSort.key) {
            holder.tvSort.typeface = Typeface.DEFAULT_BOLD
            holder.tvSort.setTextColor(ContextCompat.getColor(context, R.color.platform_main_theme))
//                holder.ivCheck.visibility = View.VISIBLE
        }
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val tvSort = itemView.tvSort!!
        val ivCheck = itemView.ivCheck!!

        init {
            itemView.setOnClickListener {
                if (adapterPosition != RecyclerView.NO_POSITION){
                    onItemSelectedListener.onSortItemSelected(sortItems[adapterPosition])
                }
            }
        }
    }
}