package com.yidianling.consultant.common.net;


import com.ydl.ydlcommon.data.http.BaseCommand;

/**
 * Created by Jim on 2018/1/11 0011.
 */

public class Command {


    //获取专家相关信息
    public static class Service extends BaseCommand {
        public String id;

        public Service(String id) {
            this.id = id;
        }

    }

    //电话倾诉列表and tag获取  同一个接口
    public static class NewCallList extends BaseCommand {

        public int page;
        public int type;
        public String name;

        public NewCallList(int page, int type) {
            this.page = page;
            this.type = type;
        }

        public NewCallList(int page, int type, String name) {
            this.page = page;
            this.type = type;
            this.name = name;
        }

    }

    //关注
    public static class FocusCmd extends BaseCommand {
        public String id;//话题id或用户uid
        public String type;//业务类型：1关注用户，2关注话题

        public FocusCmd(String id, String type) {
            this.id = id;
            this.type = type;
        }

    }


    //点赞：动态，回帖，个人主页
    public static class ZanAction extends BaseCommand {
        public String type;//业务类型：1访问用户，2动态，3话题
        public String id;//动态id,回复id,用户uid

        public ZanAction(String type, String id) {
            this.type = type;
            this.id = id;
        }

    }


    public static class ListHead extends BaseCommand {
        public ListHead() {

        }
    }

    public static class SearchDoctor extends BaseCommand {
        /**
         * 关键词
         */
        public String searchWord;
        /**
         * 类名ID
         */
        public String categorys;
        /**
         * 城市id
         */
        public int city;
        /**
         * 省份id
         */
        public int province;
        /**
         * 排序，默认 智能排序
         */
        public String reorder;
        /**
         * 咨询方式，多选，以“,”分隔连接：1,2,4,3 顺序不限
         */
        public String enquirys;
        /**
         * 咨询师年龄，多选，以“-”分隔连接：50-60-90 顺序不限
         */
        public String ages;
        /**
         * 咨询师性别,当前在线,今天有空，多选，以“,”分隔连接：1,2或者1,3,2,4,3,4 顺序不限
         */
        public String others;
        /**
         * 0按专家，1按服务：根据show_type显示不同的结构体
         */
        public int showType;
        /**
         * 页码
         */
        public int page;
    }

    public static class AdClickCount extends BaseCommand {
        public int foc_id;

        public AdClickCount(int foc_id) {
            this.foc_id = foc_id;
        }
    }

    public static class upLoadLoginStatus extends BaseCommand {
        public int os_type = 2;
        public String apiurl;
        public int errorCode;
        public String errorMsg;

        public upLoadLoginStatus(String apiurl, int errorCode, String errorMsg) {
            this.apiurl = apiurl;
            this.errorCode = errorCode;
            this.errorMsg = errorMsg;
        }

        public upLoadLoginStatus() {
        }
    }

}
