package com.yidianling.consultant.constants

/**
 * Created by xj on 2019/7/1.
 */
class ConsultBIConstants {

    companion object {
        //咨询筛选页
        const val PART_ID_CONSULT_FILTER_PAGE = "consult_filter_page"

        const val POSITION_CONSULT_TYPE_CLICK = "consult_type_click" //咨询方式
        const val POSITION_AVERAGE_SERVICE_INPUT = "average_service_input" //服务均价
        const val POSITION_AGE_CHOICE_CLICK = "age_choice_click" //年龄选择
        const val POSITION_EDU_CHOICE_CLICK = "education_background_click" //学历选择
        const val POSITION_QUALIFICATION_CHOICE_CLICK = "qualification_choice_click" //资质选择
        const val POSITION_GOOD_AT_CLICK = "good_at_click" // 擅长人群
        const val POSITION_OTHER_CHOICE_CLICK = "other_choice_click" //其他选择
        const val POSITION_CONSULT_FILTER_RESET_CLICK = "consult_filter_reset_click" //重置
        const val POSITION_CONSULT_FILTER_CHECKOUT_CLICK = "consult_filter_checkoutallconsultants_click" //查看XXX位咨询师
        const val POSITION_DAOYI_ADVERTISEMENT_CLICK="daoyi_advertisement_page|daoyi_advertisement_click"

        const val PART_ID_CONSULT_COUNSELOR_LIST_PAGE="consult_counselor_list_page"      //  咨询师列表页面浏览part_id
        const val PART_ID_YDL_USER_MAIN_PAGE="ydl_user_main_page"      //  联想词part_id
        const val POSITION_CONSULT_COUNSELOR_LIST_PAGE_VISIT="consult_counselor_list_page_visit"      //  咨询师列表页面浏览position
        const val POSITION_YDL_USER_ASSOCIATE_WORD_VISIT="ydl_user_associate_word_visit"      //  联想词曝光position
        const val POSITION_YDL_USER_ASSOCIATE_WORD_CLICK="ydl_user_associate_word_click"      //  联想词点击position
        //  咨询师列表页 banner 点击事件
        const val POSITION_CONSULT_COUNSELOR_LIST_BANNER_CLICK = "consult_counselor_list_banner_click"

    }

    //====================APP咨询列表页（app_consult_list_page）====================
    class ConsultEvent {
        companion object {
            private const val APP_CONSULT_LIST_PAGE: String =
                "app_consult_list_page|"//APP咨询列表页  partId

            const val APP_CONSULT_LIST_PAGE_VISIT: String =
                APP_CONSULT_LIST_PAGE + "app_consult_list_page_visit"//列表页浏览事件
            const val APP_CONSULT_LIST_CONSULT_GUIDE_CLICK: String =
                APP_CONSULT_LIST_PAGE + "app_consult_list_consult_guide_click "//咨询指南
            const val APP_CONSULT_LIST_ONLINE_CUSTOMER_CLICK: String =
                APP_CONSULT_LIST_PAGE + "app_consult_list_online_customer_click"//在线客服
            const val APP_CONSULT_LIST_THEME_CLICK: String =
                APP_CONSULT_LIST_PAGE + "app_consult_list_theme_click "//主题全部
            const val APP_CONSULT_LIST_AREA_CLICK: String =
                APP_CONSULT_LIST_PAGE + "app_consult_list_area_click"//地区各个地区
            const val APP_CONSULT_LIST_SORT_CLICK: String =
                APP_CONSULT_LIST_PAGE + "app_consult_list_sort_click"//排序综合排序
            const val APP_CONSULT_LIST_DOCTOR_CLICK: String =
                APP_CONSULT_LIST_PAGE + "app_consult_list_doctor_click"//每个咨询师页面点击
            const val APP_CONSULT_LIST_CHAT_CLICK: String =
                APP_CONSULT_LIST_PAGE + "app_consult_list_chat_click"//每个咨询师私聊
            const val YDL_USER_CONSULT_PAGE_STAY_VISIT: String =
                APP_CONSULT_LIST_PAGE + "ydl_user_consult_page_stay_visit"//咨询师页面停留时长
            const val YDL_USER_CONSULT_SEARCH_CLICK: String =
                APP_CONSULT_LIST_PAGE + "ydl_user_consult_search_click"//咨询师页搜索框点击事件
            const val YDL_USER_CONSULT_TYPE_CLICK: String =
                APP_CONSULT_LIST_PAGE + "ydl_user_consult_type_click"//咨询师顶部ICON 厌学专题、限时特惠、精神心理
            const val YDL_USER_CONSULT_SEARCH_CONFIRM_CLICK: String =
                APP_CONSULT_LIST_PAGE + "YDL_USER_CONSULT_SEARCH_CONFIRM_CLICK"//搜索词、底纹词点击埋点
            const val POSITION_CONSULT_COUNSELOR_CARD_CLICK =
                "consult_counselor_card_click"      //  咨询师列表点击position
            const val POSITION_CHOICE_FILTER_CLICK =
                "choice_filter_click"                        //  热门点击项position
            const val POSITION_TWO_CATEGORY_CLICK =
                "two_category_click"                          //  八大类标签选择埋点
            const val POSITION_GOODAT_CROWD_CLICK =
                "goodat_crowd_click"                          //  擅长人群埋点
            const val SEARCH_BANNERWORD_CLICK =
                "$PART_ID_YDL_USER_MAIN_PAGE|search_bannerword_click" //历史搜索、热门搜索、本周热门专家搜索
            const val CONSULT_FILTER_CITY_PAGE = "consult_filter_city_page"
            const val POPUP_ICON_CLICK = "$CONSULT_FILTER_CITY_PAGE|popup_icon_click"
            const val AUTHORIZATION_ICON_CLICK =
                "$CONSULT_FILTER_CITY_PAGE|authorization_icon_click"
            const val CITY_NAME_CLICK = "$CONSULT_FILTER_CITY_PAGE|city_name_click"
            const val CONSULT_FILTER_PRICE_PAGE = "consult_filter_price_page"
            const val PRICE_CHOICE_CLICK = "$CONSULT_FILTER_PRICE_PAGE|price_choice_click"
            const val PRICE_SLIDE_CLICK = "$CONSULT_FILTER_PRICE_PAGE|price_slide_click"
            const val BOTTOM_ICON_CLICK = "$CONSULT_FILTER_PRICE_PAGE|bottom_icon_click"
            const val PRICE_TYPE_CLICK = "$CONSULT_FILTER_PRICE_PAGE|price_type_click"
        }
    }
    class ConsultSearchListEvent {
        companion object {
            private const val CONSULT_SEARCH_LIST_PAGE: String =
                "consul_search_list_page|"//APP咨询搜索列表页  partId

            const val APP_CONSULT_SEARCH_LIST_PAGE_VISIT: String =
                CONSULT_SEARCH_LIST_PAGE + "consul_search_list_page_visit"//列表页浏览事件
            const val APP_CONSULT_SEARCH_LIST_CONSULT_ITEM_CLICK: String =
                CONSULT_SEARCH_LIST_PAGE + "consult_search_list_doctor_click "//每个咨询师页面点击
            const val APP_CONSULT_SEARCH_LIST_CHAT_CLICK: String =
                CONSULT_SEARCH_LIST_PAGE + "consult__search_list_chat_click"//每个咨询师私聊
        }
    }
    class UserMainEvent {
        companion object {

            private const val YDL_USER_MAIN_PAGE: String = "ydl_user_main_page|"//壹点灵用户版首页    partId

            const val YDL_USER_SEARCH_CLICK: String =
                YDL_USER_MAIN_PAGE + "ydl_user_search_click"  //搜索栏
            const val YDL_PRIVATE_CHAT_CLICK: String =
                YDL_USER_MAIN_PAGE + "private_chat_click"    // 点击私聊按钮
        }
    }

    class ConsultantLocationAuth {
        companion object {
            const val WHETHER_LOCATION_AUTH = "whether_location_auth"
            const val REFUSE_ALREADY = "refuse_already"
            const val RECENT_CITY = "recent_city"
        }
    }

    class Experts {
        companion object {
            //part_id
            const val EXPERTS_DETAIL = "ydl_experts_detail|"

            //2.专家主页_背景图私聊点击   sign1: 咨询师id
            const val EXPERT_BANNER_PRIVATE_CHAT_CLICK =
                EXPERTS_DETAIL + "expert_banner_private_chat_click"

            //3.专家主页_背景图预约点击   sign1: 咨询师id
            const val EXPERT_BANNER_IMMEDIATELY_BOOKING_CLICK = EXPERTS_DETAIL +
                    "expert_banner_immediately_booking_click"

            //3.专家主页_背景图预约点击   sign1: 咨询师id
            const val BOOKING_PRODUCT_POPUP_PAGE_CLICK = EXPERTS_DETAIL +
                    "booking_product_popup_page_click"

        }
    }
}