package com.yidianling.consultant.http.hotsearch

import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.consultant.bean.FunctionWordConsultBean
import com.yidianling.consultant.bean.HotSearchBean
import com.yidianling.consultant.bean.HotSearchKeyWordDataBean
import com.yidianling.consultant.bean.SearchWordsBean
import com.yidianling.consultant.http.ExpertSearchParam
import com.yidianling.consultant.model.SearchApi
import com.yidianling.consultant.model.bean.FunctionWordBean
import io.reactivex.Observable

/**
 * @author yuanWai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/11
 */
class HotSearchHttpImpl : IHotSearchHttp {

    companion object {
        fun getInstance(): HotSearchHttpImpl {
            return Holder.INSTANCE
        }

        fun clearSearchApi() {
            Holder.INSTANCE.searchApi = null
        }
    }

    object Holder {
        val INSTANCE = HotSearchHttpImpl()
    }

    private var searchApi: SearchApi? = null

    private fun getSearchApi(): SearchApi {
        if (searchApi == null) {
            searchApi = YDLHttpUtils.Companion.obtainApi(SearchApi::class.java)
        }
        return searchApi!!
    }

    override fun searchData(): Observable<BaseAPIResponse<HotSearchBean>> {
        return RxUtils.mapObservable(ExpertSearchParam(""))
            .flatMap {
                getSearchApi().searchPage()
            }
    }

    override fun searchHotWordData(map: HashMap<String, Any>): Observable<BaseAPIResponse<MutableList<FunctionWordBean>>> {
        return getSearchApi().searchFunctionWord(map)
    }

    override fun getSearchWords(map: HashMap<String, Any>): Observable<BaseAPIResponse<SearchWordsBean>> {
        return getSearchApi().getSearchWords(map)
    }
}