package com.yidianling.consultant.http.hotsearch

import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.yidianling.consultant.bean.HotSearchBean
import com.yidianling.consultant.bean.SearchWordsBean
import com.yidianling.consultant.model.bean.FunctionWordBean
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/26
 */
interface IHotSearchHttp {
    /**
     * 搜索页请求
     */
    fun searchData(): Observable<BaseAPIResponse<HotSearchBean>>

    /**
     * 搜索页请求热门词
     */
    fun searchHotWordData(map: HashMap<String, Any>): Observable<BaseAPIResponse<MutableList<FunctionWordBean>>>

    /**
     * 搜索联想词请求
     */
    fun getSearchWords(map: HashMap<String, Any>): Observable<BaseAPIResponse<SearchWordsBean>>
}