package com.yidianling.consultant.model.bean

import com.yidianling.consultant.bean.ExpertSearchProductsBean
import com.yidianling.consultant.bean.ExpertSearchTagsIconBean

/**
 * @author yuanWai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/11
 */
data class ExpertServiceItem(
    /**
     * 专家ID
     */
    val id: String,
    /**
     * 专家uid
     */
    val uid: String?,
    /**
     * 专家名称
     */
    val doctor_name: String?,
    /**
     * 跳转路由地址（正常为专家主页地址）
     */
    val link_url: String?,
    /**
     * 专家头像地址
     */
    val head: String?,
    /**
     * 专家是否在线 1.在线
     */
    val chat_status: Int?,
    /**
     * 能力等级 1.实习 2.新手 3.精英
     */
    val abilityLevel: Int?,
    /**
     * 有免费咨询：1.有，2.无
     */
    val has_servicefree_consult: Int?,
    /**
     * 活动图标
     */
    val activityImg: String?,
    /**
     * 是否参加活动
     */
    val joinActivity: Boolean?,
    /**
     * 是否新入驻：true:是，false:否
     */
    var is_new_enter: Boolean?,
    /**
     * 好评率(倾诉+咨询)
     */
    var evaluation_average_score: Float = 0f,
    /**
     * 是否抗疫先锋图标
     */
    var fightEpidemicIconShow: Boolean = false,
    /**
     * 评价数(咨询订单数)
     */
    var evaluate_num: Int = 0,
    /**
     * 咨询最低价
     */
    val min_price: String?,
    /**
     * 资质材料
     */
    val title: String?,
    /**
     * 已帮助人数(咨询人数)
     */
    val help_num: String?,
    /**
     * 月售时长
     */
    var p30d_sold_hour: Float = 0f,
    /**
     * 服务时长
     */
    var sum_service_time: Float = 0f,
    /**
     * 服务
     */
    val doctor_products: MutableList<ExpertSearchProductsBean>?,
    /**
     * 标签图片
     */
    val icons: ExpertSearchTagsIconBean?,
//    /**
//     * 今日是否可约
//     */
//    val booking_status: Int,
//    /**
//     * 咨询状态  1-待服务 2-服务中
//     */
//    var consult_status: Int,
//    /**
//     * 倾诉状态  1-待服务 2-服务中
//     */
//    var listen_status: Int,

    var open_chat_agency: Int,

    var service_status: Int,

    var is_free_today: Int,

    /**
     * 私聊人数
     */
    var chat_num: Int = 0,
    /**
     * 个人铭言
     */
    val famous_remark: String?,
    /**
     * 省
     */
    val province: String?,
    /**
     * 市
     */
    val city: String?,
    /**
     * 私聊按钮的文案(如果不为空则取这个字段的值，如果为空 则默认为：“私聊”)
     */
    val chat_btn_text: String?,

    /**
     * 新标签分类
     */
    val feature_tags: ArrayList<FeatureTag>?,

    /**
     * 是否是头部headView
     */
    val is_head_view: Boolean = false,
    /**
     * 搜索词
     */
    val search_content: String,
    /**
     * 联想词
     */
    val related_word: String,
    /**
     * 地区
     */
    val display_region: String,

    /**
     * 是否展示公益图标
     */
    val has_servicefree_experience: Int?


) {
    constructor(is_head_view: Boolean, search_content: String, related_word: String) : this(
        "", "", "", "", "",
        1, 1, 1, "", false, true,
        1f, false, 0, "", "", "", 1f, 1f,
        null, null, 1, 1, 1, 1,
        "", "", "", "", null, is_head_view, search_content, related_word, "", 1
    )
}

data class FeatureTag(
    val tag_id: String,
    val tag_name: String,
    val is_highlight: Boolean,   // 是否高亮
    val type: String             // 标签类型
)