package com.yidianling.consultant.presenter

import android.annotation.SuppressLint
import android.content.Context
import android.text.TextUtils
import com.google.gson.Gson
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.ydl.ydlcommon.mvp.base.BasePresenter
import com.ydl.ydlcommon.utils.RxLifecycleUtils
import com.ydl.ydlcommon.utils.YDLAsyncUtils
import com.ydl.ydlcommon.utils.YDLCacheUtils
import com.yidianling.common.tools.ToastUtil
import com.yidianling.consultant.bean.HotSearchBean
import com.yidianling.consultant.contract.IHotSearchContract
import com.yidianling.consultant.model.HotSearchModelImpl
import com.yidianling.consultant.model.bean.FunctionWordBean
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import io.reactivex.schedulers.Schedulers

/**
 * @author yuanwai
 * @描述:搜索页面逻辑实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/3/19
 */
class HotSearchPresenterImpl : BasePresenter<IHotSearchContract.View, IHotSearchContract.Model>(), IHotSearchContract.Presenter{

    /**
     * 实例化数据模型
     */
    override fun createModel(): IHotSearchContract.Model {
        return HotSearchModelImpl()
    }

    override fun localData(context: Context) {
        YDLAsyncUtils.asyncAsResult(object : YDLAsyncUtils.AsyncObjecyerResult{
            override fun doAsyncAction(): Any {
                return YDLCacheUtils.getHotSearchData()
            }

            override fun asyncResult(`object`: Any?) {
                //如果没有缓存数据，显示加载框
                if (`object` !is String || TextUtils.isEmpty(`object`)){

                }

                if (`object` is String){
                    val gson = Gson()
                    val bean = gson.fromJson<HotSearchBean>(`object`,HotSearchBean::class.java)
                    if(null != bean){
                        mView.searchDataResponse(bean)
                    }
                }
                searchData()
            }
        })
    }

    /**
     * 搜索页接口
     */
    @SuppressLint("CheckResult")
    override fun searchData() {
         mModel.searchData().map { it }
                .filter { it != null }
                .compose(RxLifecycleUtils.bindToLifecycle(mView!!))
                .observeOn(AndroidSchedulers.mainThread())
             .subscribe(Consumer {
                 mView.searchDataResponse(it)
                 YDLCacheUtils.saveHotSearchData(Gson().toJson(it))
             }, object : ThrowableConsumer() {
                 override fun accept(msg: String) {
                     mView.requestFail()
                 }
             })
    }

    @SuppressLint("CheckResult")
    override fun searchHotWordData(map: HashMap<String, Any>) {
        mModel.searchHotWordData(map).compose(RxLifecycleUtils.bindToLifecycle(mView!!))
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(Consumer {
                mView.searchHotWordData(it.data)
            }, object : ThrowableConsumer() {
                override fun accept(msg: String) {
                    mView.requestFail()
                }
            })
    }

    @SuppressLint("CheckResult")
    override fun getSearchWords(
        map: HashMap<String, Any>,
        searchContent: String,
        isClickWords: Boolean
    ) {
        mModel.getSearchWords(map)
//            .debounce(500L, TimeUnit.MILLISECONDS)
            .compose(RxLifecycleUtils.bindToLifecycle(mView))
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(Consumer {
                mView.getSearchWordsSuccess(it, searchContent, isClickWords)
            }, object : ThrowableConsumer() {
                override fun accept(msg: String) {
                   ToastUtil.toastShort(msg)
                }
            })
    }
}