package com.yidianling.consultant.preview;

import android.app.Activity;
import android.content.Intent;
import android.os.Parcelable;

import androidx.fragment.app.Fragment;

import java.util.ArrayList;
import java.util.List;

/**
 * @author rainb
 */
public class GPreviewBuilder {

    private Activity mContext;
    private Intent intent;
    private Class className;

    private GPreviewBuilder(Activity activity) {
        mContext = activity;
        intent = new Intent();
    }

    public static GPreviewBuilder form(Activity activity) {
        return new GPreviewBuilder(activity);
    }

    public static GPreviewBuilder from(Fragment fragment) {
        return new GPreviewBuilder(fragment.getActivity());
    }

    /***
     * 设置数据源
     * @param imgUrls 数据
     *@param   <T>    你的实体类类型
     * @return GPreviewBuilder
     * **/
    public <T extends IThumbViewInfo> GPreviewBuilder setData(List<T> imgUrls) {
        intent.putParcelableArrayListExtra("imagePaths", new ArrayList<Parcelable>(imgUrls));
        return this;
    }


    /***
     * 设置默认索引
     * @param currentIndex 数据
     * @return GPreviewBuilder
     * **/
    public GPreviewBuilder setCurrentIndex(int currentIndex) {
        intent.putExtra("position", currentIndex);
        return this;
    }

    /***
     * 设置指示器类型
     * @param indicatorType 枚举
     * @return GPreviewBuilder
     * **/
    public GPreviewBuilder setType(IndicatorType indicatorType) {
        intent.putExtra("type", indicatorType);
        return this;
    }


    public void start() {
        if (className == null) {
            intent.setClass(mContext, GPreviewActivity.class);
        } else {
            intent.setClass(mContext, className);
        }
        mContext.startActivity(intent);
        mContext.overridePendingTransition(0, 0);
        intent = null;
        mContext = null;
    }

    public GPreviewBuilder setFullscreen(boolean isFullscreen) {
        intent.putExtra("isFullscreen", isFullscreen);
        return this;
    }

    public GPreviewBuilder setToUid(String toUid){
        intent.putExtra("toUid", toUid);
        return this;
    }

    public GPreviewBuilder setDoctorId(String doctorId){
        intent.putExtra("doctorId", doctorId);
        return this;
    }

    /***
     * 指示器类型
     * ***/
    public enum IndicatorType {
        Dot, Number
    }
}
