package com.yidianling.consultant.ui.view

import android.content.Context
import android.graphics.drawable.BitmapDrawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.PopupWindow
import androidx.fragment.app.FragmentActivity
import com.yidianling.common.tools.RxImageTool
import com.yidianling.common.tools.asFragmentActivity
import com.yidianling.consultant.R
import com.yidianling.consultant.adapter.SortAdapter
import com.yidianling.consultant.layoutmanager.FlowLayoutManager
import com.yidianling.consultant.listener.OnCategoriesSelectedListener
import com.yidianling.consultant.model.bean.AllFilter
import com.yidianling.consultant.model.bean.ChildrenBean
import com.yidianling.consultant.ui.view.topView.EightCategoryView
import kotlinx.android.synthetic.main.consultant_ui_eight_category_popup_window.view.*
import kotlinx.android.synthetic.main.consultant_ui_subject_popup_window.view.*
import kotlinx.android.synthetic.main.consultant_ui_subject_popup_window.view.btnConfirm
import kotlinx.android.synthetic.main.consultant_ui_subject_popup_window.view.btn_reset

/**
 * 主题弹窗
 * Created by zqk on 17-9-15.
 */
class EightCategoryPopupWindow(context: Context, allFilter: AllFilter) :
    PopupWindow(ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dp2px(566f)) {
    private var view: View = LayoutInflater.from(context)
        .inflate(R.layout.consultant_ui_eight_category_popup_window, null)
    var mAllFilter: AllFilter
    private var context: Context
    var onSubjectsSelectedListener: OnCategoriesSelectedListener? = null
    lateinit var mutableList: MutableList<MutableList<ChildrenBean>>
    private val signList = ArrayList<String>()      // 用于埋点


    init {
        this.contentView = view
        this.isFocusable = true
        this.context = context
        @Suppress("DEPRECATION")
        this.setBackgroundDrawable(BitmapDrawable())
        this.isOutsideTouchable = true
        mAllFilter = allFilter
        initView()
    }

    fun setListener(onSubjectsSelectedListener: OnCategoriesSelectedListener) {
        this.onSubjectsSelectedListener = onSubjectsSelectedListener
        val eightCategoryView = EightCategoryView(context, false)
        eightCategoryView.setData(mutableList, mAllFilter, onSubjectsSelectedListener, false)
        view.eight_category_fl.addView(eightCategoryView)
    }

    private fun initView() {
        inputMethodMode = INPUT_METHOD_NEEDED


        mutableList = mutableListOf<MutableList<ChildrenBean>>()
        mutableList.add(mAllFilter.childList)
        mutableList.add(mAllFilter.stressList)
        mutableList.add(mAllFilter.loveEmotionList)
        mutableList.add(mAllFilter.marriedFamilyList)
        mutableList.add(mAllFilter.personalGrowthList)
        mutableList.add(mAllFilter.interpersonalRelationshipList)
        mutableList.add(mAllFilter.careerDevelopmentList)
        mutableList.add(mAllFilter.mentalHealthList)


//        val fragmentTransaction = context?.asFragmentActivity()?.supportFragmentManager?.beginTransaction()
//        val searchFragment=ConsultCategoryFragment()
//        fragmentTransaction?.add(R.id.eight_category_fl,searchFragment)?.commit()


    }


}