package com.yidianling.consultant.ui.view

import android.content.Context
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Rect
import android.graphics.drawable.ColorDrawable
import androidx.core.view.ViewCompat
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import com.yidianling.common.tools.RxImageTool


/**
 * 专家或咨询列表条目添加灰色间隔
 * Created by zqk on 17-9-21.
 */
class ExpertItemDecoration(val context: Context) : RecyclerView.ItemDecoration() {

    var space = RxImageTool.dp2px( 7f)

    override fun onDraw(c: Canvas, parent: RecyclerView) {
        val view = ColorDrawable(Color.parseColor("#f3f3f3"))
        val left = parent.paddingLeft
        val right = parent.width - parent.paddingRight
        val childCount = parent.childCount
        for (i in 0 until childCount) {
            val child = parent.getChildAt(i)
            val params = child
                    .layoutParams as RecyclerView.LayoutParams
            val top = child.bottom + params.bottomMargin +
                    Math.round(ViewCompat.getTranslationY(child))
            val bottom = top + space
            if (i == 0) {
                view.setBounds(left, child.top - space, right, child.top)
                view.draw(c)
            }
            view.setBounds(left, top, right, bottom)
            view.draw(c)
        }
    }


    override fun getItemOffsets(outRect: Rect, view: View, parent: RecyclerView, state: RecyclerView.State) {
        if (parent.getChildAdapterPosition(view) == 0) {
            outRect.top = 1
        }
        outRect.bottom = space

    }
}