package com.yidianling.consultant.ui.view

import android.content.Context
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import android.util.AttributeSet
import android.view.MotionEvent


// 判断 X 轴的 Y 轴的 移动的距离差 来判断是否 需要拦截事件
class ExpertSearchSwipeRefreshLayout(context: Context, attrs: AttributeSet) :
    SwipeRefreshLayout(context, attrs) {
    // 上一次触摸时的X坐标
    private var mPreDownX: Float = 0.toFloat()
    private var mPreDownY: Float = 0.toFloat()
    override fun onInterceptTouchEvent(ev: MotionEvent): Boolean {
        when (ev.action) {
            MotionEvent.ACTION_DOWN -> {
                mPreDownX = ev.x
                mPreDownY = ev.y
            }
            MotionEvent.ACTION_MOVE -> {
                val eventX = ev.x
                val eventY = ev.y
                val xAbs = Math.abs(eventX - mPreDownX)
                val yAbs = Math.abs(eventY - mPreDownY)
                // 如果 X 轴移动的 距离大于 Y 轴移动的距离
                // 那么 不拦截 触摸事件 交给 下面的处理
                if (xAbs > yAbs) {
                    return false
                }
            }
        }
        return super.onInterceptTouchEvent(ev)
    }
}
